/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class SegmentAnalyzer {
    private static final Logger log = new Logger(SegmentAnalyzer.class);
    private static final int NUM_BYTES_IN_TIMESTAMP = 10;
    private static final int NUM_BYTES_IN_TEXT_FLOAT = 8;
    private final EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes;

    public SegmentAnalyzer(EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes) {
        this.analysisTypes = analysisTypes;
    }

    public long numRows(Segment segment) {
        return ((PhysicalSegmentInspector)Preconditions.checkNotNull((Object)segment.as(PhysicalSegmentInspector.class), (Object)"PhysicalSegmentInspector")).getNumRows();
    }

    public Map<String, ColumnAnalysis> analyze(Segment segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        PhysicalSegmentInspector segmentInspector = segment.as(PhysicalSegmentInspector.class);
        QueryableIndex index = segment.as(QueryableIndex.class);
        int numRows = segmentInspector != null ? segmentInspector.getNumRows() : 0;
        LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap<String, ColumnAnalysis>();
        RowSignature rowSignature = segment.asCursorFactory().getRowSignature();
        for (String columnName : rowSignature.getColumnNames()) {
            ColumnAnalysis analysis;
            ColumnCapabilities capabilities = segmentInspector != null ? segmentInspector.getColumnCapabilities(columnName) : null;
            if (capabilities == null) {
                log.warn("Unknown column type for column[%s]", columnName);
                columns.put(columnName, ColumnAnalysis.error("unknown_type"));
                continue;
            }
            try {
                switch ((ValueType)capabilities.getType()) {
                    case LONG: {
                        int bytesPerRow = "__time".equals(columnName) ? 10 : 8;
                        analysis = this.analyzeNumericColumn(capabilities, numRows, bytesPerRow);
                        break;
                    }
                    case FLOAT: {
                        analysis = this.analyzeNumericColumn(capabilities, numRows, 8);
                        break;
                    }
                    case DOUBLE: {
                        analysis = this.analyzeNumericColumn(capabilities, numRows, 8);
                        break;
                    }
                    case STRING: {
                        if (index != null) {
                            analysis = this.analyzeStringColumn(capabilities, index.getColumnHolder(columnName));
                            break;
                        }
                        analysis = this.analyzeStringColumn(capabilities, segmentInspector, segment.asCursorFactory(), columnName);
                        break;
                    }
                    case ARRAY: {
                        analysis = this.analyzeArrayColumn(capabilities);
                        break;
                    }
                    case COMPLEX: {
                        ColumnHolder columnHolder = index != null ? index.getColumnHolder(columnName) : null;
                        analysis = this.analyzeComplexColumn(capabilities, numRows, columnHolder);
                        break;
                    }
                    default: {
                        log.warn("Unknown column type[%s] for column[%s].", capabilities.asTypeString(), columnName);
                        analysis = ColumnAnalysis.error(StringUtils.format("unknown_type_%s", capabilities.asTypeString()));
                        break;
                    }
                }
            }
            catch (RuntimeException re) {
                log.warn(re, "Error analyzing column[%s] of type[%s]", columnName, capabilities.asTypeString());
                analysis = ColumnAnalysis.error(re.getMessage());
            }
            columns.put(columnName, analysis);
        }
        return columns;
    }

    public boolean analyzingSize() {
        return this.analysisTypes.contains(SegmentMetadataQuery.AnalysisType.SIZE);
    }

    public boolean analyzingCardinality() {
        return this.analysisTypes.contains(SegmentMetadataQuery.AnalysisType.CARDINALITY);
    }

    public boolean analyzingMinMax() {
        return this.analysisTypes.contains(SegmentMetadataQuery.AnalysisType.MINMAX);
    }

    private ColumnAnalysis analyzeNumericColumn(ColumnCapabilities capabilities, int length, int sizePerRow) {
        long size = 0L;
        ColumnAnalysis.Builder bob = ColumnAnalysis.builder().withCapabilities(capabilities);
        if (this.analyzingSize()) {
            if (capabilities.hasMultipleValues().isTrue()) {
                return bob.withErrorMessage("multi_value").build();
            }
            size = (long)length * (long)sizePerRow;
        }
        return bob.withSize(size).build();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColumnAnalysis analyzeStringColumn(ColumnCapabilities capabilities, ColumnHolder columnHolder) {
        void var4_12;
        void var3_7;
        int cardinality;
        DictionaryEncodedStringValueIndex valueIndex;
        Object var3_3 = null;
        Object var4_8 = null;
        long size = 0L;
        ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
        DictionaryEncodedStringValueIndex dictionaryEncodedStringValueIndex = valueIndex = indexSupplier == null ? null : indexSupplier.as(DictionaryEncodedStringValueIndex.class);
        if (valueIndex != null) {
            cardinality = valueIndex.getCardinality();
            if (this.analyzingSize()) {
                for (int i = 0; i < cardinality; ++i) {
                    String value = (String)valueIndex.getValue(i);
                    if (value == null) continue;
                    size += (long)StringUtils.estimatedBinaryLengthAsUTF8(value) * (long)valueIndex.getBitmap(i).size();
                }
            }
            if (!this.analyzingMinMax() || cardinality <= 0) return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(this.analyzingCardinality() ? cardinality : 0).withMinValue(var3_7).withMaxValue(var4_12).build();
            Comparable comparable = (Comparable)valueIndex.getValue(0);
            Comparable comparable2 = (Comparable)valueIndex.getValue(cardinality - 1);
            return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(this.analyzingCardinality() ? cardinality : 0).withMinValue(var3_7).withMaxValue(var4_12).build();
        } else if (capabilities.isDictionaryEncoded().isTrue()) {
            try (BaseColumn column = columnHolder.getColumn();){
                if (column instanceof DictionaryEncodedColumn) {
                    DictionaryEncodedColumn theColumn = (DictionaryEncodedColumn)column;
                    cardinality = theColumn.getCardinality();
                    if (!this.analyzingMinMax() || cardinality <= 0) return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(this.analyzingCardinality() ? cardinality : 0).withMinValue(var3_7).withMaxValue(var4_12).build();
                    Object ActualType = theColumn.lookupName(0);
                    Object ActualType2 = theColumn.lookupName(cardinality - 1);
                    return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(this.analyzingCardinality() ? cardinality : 0).withMinValue(var3_7).withMaxValue(var4_12).build();
                }
                cardinality = 0;
                return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(this.analyzingCardinality() ? cardinality : 0).withMinValue(var3_7).withMaxValue(var4_12).build();
            }
            catch (IOException e) {
                return ColumnAnalysis.builder().withCapabilities(capabilities).withErrorMessage(e.getMessage()).build();
            }
        } else {
            cardinality = 0;
        }
        return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(this.analyzingCardinality() ? cardinality : 0).withMinValue(var3_7).withMaxValue(var4_12).build();
    }

    private ColumnAnalysis analyzeStringColumn(ColumnCapabilities capabilities, @Nullable PhysicalSegmentInspector analysisInspector, CursorFactory cursorFactory, String columnName) {
        int cardinality = 0;
        long size = 0L;
        Comparable min = null;
        Comparable max = null;
        if (this.analyzingCardinality() && analysisInspector != null) {
            cardinality = analysisInspector.getDimensionCardinality(columnName);
        }
        if (this.analyzingMinMax() && analysisInspector != null) {
            min = analysisInspector.getMinValue(columnName);
            max = analysisInspector.getMaxValue(columnName);
        }
        if (this.analyzingSize()) {
            try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
                Cursor cursor = cursorHolder.asCursor();
                if (cursor != null) {
                    DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName));
                    while (!cursor.isDone()) {
                        IndexedInts row = selector.getRow();
                        int rowSize = row.size();
                        for (int i = 0; i < rowSize; ++i) {
                            String dimVal = selector.lookupName(row.get(i));
                            if (dimVal == null || dimVal.isEmpty()) continue;
                            size += (long)StringUtils.estimatedBinaryLengthAsUTF8(dimVal);
                        }
                        cursor.advance();
                    }
                }
            }
        }
        return ColumnAnalysis.builder().withCapabilities(capabilities).withSize(size).withCardinality(cardinality).withMinValue(min).withMaxValue(max).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ColumnAnalysis analyzeComplexColumn(ColumnCapabilities capabilities, int numCells, @Nullable ColumnHolder columnHolder) {
        TypeSignature<ValueType> typeSignature = capabilities == null ? ColumnType.UNKNOWN_COMPLEX : capabilities;
        String typeName = typeSignature.getComplexTypeName();
        ColumnAnalysis.Builder bob = ColumnAnalysis.builder().withType(ColumnTypeFactory.ofType(typeSignature)).withTypeName(typeName);
        try (BaseColumn theColumn = columnHolder != null ? columnHolder.getColumn() : null;){
            if (capabilities != null) {
                bob.hasMultipleValues(capabilities.hasMultipleValues().isTrue()).hasNulls(capabilities.hasNulls().isMaybeTrue());
            }
            if (theColumn != null && !(theColumn instanceof ComplexColumn)) {
                ColumnAnalysis columnAnalysis = bob.withErrorMessage(StringUtils.format("[%s] is not a [%s]", theColumn.getClass().getName(), ComplexColumn.class.getName())).build();
                return columnAnalysis;
            }
            ComplexColumn complexColumn = (ComplexColumn)theColumn;
            long size = 0L;
            if (this.analyzingSize() && complexColumn != null) {
                ComplexMetricSerde serde;
                ComplexMetricSerde complexMetricSerde = serde = typeName == null ? null : ComplexMetrics.getSerdeForType(typeName);
                if (serde == null) {
                    ColumnAnalysis columnAnalysis = bob.withErrorMessage(StringUtils.format("unknown_complex_%s", typeName)).build();
                    return columnAnalysis;
                }
                Function<Object, Long> inputSizeFn = serde.inputSizeFn();
                if (inputSizeFn != null) {
                    for (int i = 0; i < numCells; size += ((Long)inputSizeFn.apply(complexColumn.getRowValue(i))).longValue(), ++i) {
                    }
                }
            }
            ColumnAnalysis columnAnalysis = bob.withSize(size).build();
            return columnAnalysis;
        }
        catch (IOException e) {
            return bob.withErrorMessage(e.getMessage()).build();
        }
    }

    private ColumnAnalysis analyzeArrayColumn(ColumnCapabilities capabilities) {
        return ColumnAnalysis.builder().withCapabilities(capabilities).build();
    }
}

