/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.ScanOperatorFactory;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQuery
extends BaseQuery<RowsAndColumns> {
    private final RowSignature rowSignature;
    private final List<OperatorFactory> operators;
    private final List<OperatorFactory> leafOperators;

    private static DataSource validateMaybeRewriteDataSource(DataSource dataSource, boolean hasLeafs) {
        if (hasLeafs) {
            return dataSource;
        }
        if (dataSource instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)dataSource).getQuery();
            if (subQuery instanceof ScanQuery) {
                return subQuery.getDataSource();
            }
            return dataSource;
        }
        if (dataSource instanceof InlineDataSource) {
            return dataSource;
        }
        throw new IAE("WindowOperatorQuery must run on top of a query or inline data source, got [%s]", dataSource);
    }

    @JsonCreator
    public WindowOperatorQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec intervals, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="outputSignature") RowSignature rowSignature, @JsonProperty(value="operatorDefinition") List<OperatorFactory> operators, @JsonProperty(value="leafOperators") List<OperatorFactory> leafOperators) {
        super(WindowOperatorQuery.validateMaybeRewriteDataSource(dataSource, leafOperators != null), intervals, context);
        this.rowSignature = rowSignature;
        this.operators = operators;
        if (leafOperators == null) {
            Query subQuery;
            this.leafOperators = new ArrayList<OperatorFactory>();
            if (dataSource instanceof QueryDataSource && (subQuery = ((QueryDataSource)dataSource).getQuery()) instanceof ScanQuery) {
                ScanQuery scan = (ScanQuery)subQuery;
                ArrayList<ColumnWithDirection> ordering = new ArrayList<ColumnWithDirection>();
                for (OrderBy orderBy : scan.getOrderBys()) {
                    ordering.add(new ColumnWithDirection(orderBy.getColumnName(), Order.DESCENDING == orderBy.getOrder() ? ColumnWithDirection.Direction.DESC : ColumnWithDirection.Direction.ASC));
                }
                if (ordering.isEmpty()) {
                    ordering = null;
                }
                this.leafOperators.add(new ScanOperatorFactory(null, scan.getFilter(), scan.getOffsetLimit(), scan.getColumns(), scan.getVirtualColumns().isEmpty() ? null : scan.getVirtualColumns(), ordering));
            }
        } else {
            this.leafOperators = leafOperators;
        }
    }

    @JsonProperty(value="operatorDefinition")
    public List<OperatorFactory> getOperators() {
        return this.operators;
    }

    @JsonProperty(value="leafOperators")
    public List<OperatorFactory> getLeafOperators() {
        return this.leafOperators;
    }

    @JsonProperty(value="outputSignature")
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    @Override
    public RowSignature getResultRowSignature(RowSignature.Finalization finalization) {
        return this.getRowSignature();
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    @Nullable
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "windowOperator";
    }

    @Override
    public Query<RowsAndColumns> withOverriddenContext(Map<String, Object> contextOverride) {
        return new WindowOperatorQuery(this.getDataSource(), this.getQuerySegmentSpec(), WindowOperatorQuery.computeOverriddenContext(this.getContext(), contextOverride), this.rowSignature, this.operators, this.leafOperators);
    }

    @Override
    public Query<RowsAndColumns> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new WindowOperatorQuery(this.getDataSource(), spec, this.getContext(), this.rowSignature, this.operators, this.leafOperators);
    }

    @Override
    public Query<RowsAndColumns> withDataSource(DataSource dataSource) {
        return new WindowOperatorQuery(dataSource, this.getQuerySegmentSpec(), this.getContext(), this.rowSignature, this.operators, this.leafOperators);
    }

    public Query<RowsAndColumns> withOperators(List<OperatorFactory> operators) {
        return new WindowOperatorQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.getContext(), this.rowSignature, operators, this.leafOperators);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WindowOperatorQuery that = (WindowOperatorQuery)o;
        return Objects.equals(this.rowSignature, that.rowSignature) && Objects.equals(this.operators, that.operators) && Objects.equals(this.leafOperators, that.leafOperators);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rowSignature, this.operators, this.leafOperators);
    }

    public String toString() {
        return "WindowOperatorQuery{dataSource='" + this.getDataSource() + "', querySegmentSpec=" + this.getQuerySegmentSpec() + ", context=" + this.getContext() + ", rowSignature=" + this.rowSignature + ", operators=" + this.operators + ", leafOperators=" + this.leafOperators + "}";
    }
}

