/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.join;

import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.operator.Operator;

public class JoinPartDefn {
    private final Operator op;
    private final List<String> joinFields;
    private final List<String> projectFields;

    public static Builder builder(Operator op) {
        return new Builder(op);
    }

    public JoinPartDefn(Operator op, List<String> joinFields, List<String> projectFields) {
        this.op = op;
        this.joinFields = joinFields;
        this.projectFields = projectFields;
    }

    public Operator getOp() {
        return this.op;
    }

    public List<String> getJoinFields() {
        return this.joinFields;
    }

    public List<String> getProjectFields() {
        return this.projectFields;
    }

    public static class Builder {
        private final Operator op;
        private List<String> joinFields;
        private List<String> projectFields;

        public Builder(Operator op) {
            this.op = op;
        }

        public Builder joinOn(String ... fields) {
            this.joinFields = Arrays.asList(fields);
            return this;
        }

        public Builder project(String ... fields) {
            this.projectFields = Arrays.asList(fields);
            return this;
        }

        public JoinPartDefn build() {
            return new JoinPartDefn(this.op, this.joinFields, this.projectFields);
        }
    }
}

