/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.List;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.druid.query.search.SearchQueryRunner;
import org.apache.druid.query.search.SearchStrategy;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.filter.Filters;

public class CursorOnlyStrategy
extends SearchStrategy {
    public static final String NAME = "cursorOnly";

    public static CursorOnlyStrategy of(SearchQuery query) {
        return new CursorOnlyStrategy(query);
    }

    private CursorOnlyStrategy(SearchQuery query) {
        super(query);
    }

    @Override
    public List<SearchQueryExecutor> getExecutionPlan(SearchQuery query, Segment segment) {
        List<DimensionSpec> dimensionSpecs = CursorOnlyStrategy.getDimsToSearch(segment, query.getDimensions());
        return ImmutableList.of((Object)new CursorBasedExecutor(query, segment, dimensionSpecs));
    }

    public static class CursorBasedExecutor
    extends SearchQueryExecutor {
        public CursorBasedExecutor(SearchQuery query, Segment segment, List<DimensionSpec> dimensionSpecs) {
            super(query, segment, dimensionSpecs);
        }

        @Override
        public Object2IntRBTreeMap<SearchHit> execute(int limit) {
            CursorFactory adapter = this.segment.asCursorFactory();
            CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(this.query.getSingleInterval()).setFilter(Filters.convertToCNFFromQueryContext(this.query, Filters.toFilter(this.query.getFilter()))).setVirtualColumns(this.query.getVirtualColumns()).setPhysicalColumns(this.query.getRequiredColumns()).setQueryContext(this.query.context()).build();
            try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
                Cursor cursor = cursorHolder.asCursor();
                Object2IntRBTreeMap retVal = new Object2IntRBTreeMap(this.query.getSort().getComparator());
                retVal.defaultReturnValue(0);
                if (cursor == null) {
                    Object2IntRBTreeMap object2IntRBTreeMap = retVal;
                    return object2IntRBTreeMap;
                }
                Object2IntRBTreeMap selectorPlusList = DimensionHandlerUtils.createColumnSelectorPluses(SearchQueryRunner.SEARCH_COLUMN_SELECTOR_STRATEGY_FACTORY, this.dimsToSearch, cursor.getColumnSelectorFactory());
                while (!cursor.isDone()) {
                    for (Object2IntRBTreeMap selectorPlus : selectorPlusList) {
                        ((SearchQueryRunner.SearchColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).updateSearchResultSet(selectorPlus.getOutputName(), selectorPlus.getSelector(), this.searchQuerySpec, limit, (Object2IntRBTreeMap<SearchHit>)retVal);
                        if (retVal.size() < limit) continue;
                        Object2IntRBTreeMap object2IntRBTreeMap = retVal;
                        return object2IntRBTreeMap;
                    }
                    cursor.advance();
                }
                Object2IntRBTreeMap object2IntRBTreeMap = retVal;
                return object2IntRBTreeMap;
            }
        }
    }
}

