/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.types.NullableNumericTopNColumnAggregatesProcessor;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.Cursor;

public class LongTopNColumnAggregatesProcessor
extends NullableNumericTopNColumnAggregatesProcessor<BaseLongColumnValueSelector> {
    private Long2ObjectMap<Aggregator[]> aggregatesStore;

    public LongTopNColumnAggregatesProcessor(Function<Object, Object> converter) {
        super(converter);
    }

    @Override
    Aggregator[] getValueAggregators(TopNQuery query, BaseLongColumnValueSelector selector, Cursor cursor) {
        long key = selector.getLong();
        return (Aggregator[])this.aggregatesStore.computeIfAbsent(key, k -> BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs()));
    }

    @Override
    public void initAggregateStore() {
        this.nullValueAggregates = null;
        this.aggregatesStore = new Long2ObjectOpenHashMap();
    }

    @Override
    Map<?, Aggregator[]> getAggregatesStore() {
        return this.aggregatesStore;
    }

    @Override
    Object convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
        return this.converter.apply(aggregatorStoreKey);
    }
}

