/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public interface Segment
extends Closeable {
    public SegmentId getId();

    public Interval getDataInterval();

    @Nullable
    public QueryableIndex asQueryableIndex();

    @Deprecated
    default public StorageAdapter asStorageAdapter() {
        throw DruidException.defensive("asStorageAdapter is no longer supported, use Segment.asCursorFactory to build cursors, or Segment.as(..) to get various metadata information instead", new Object[0]);
    }

    public CursorFactory asCursorFactory();

    @Nullable
    default public <T> T as(@Nonnull Class<T> clazz) {
        if (clazz.equals(CursorFactory.class)) {
            return (T)this.asCursorFactory();
        }
        if (clazz.equals(QueryableIndex.class)) {
            return (T)this.asQueryableIndex();
        }
        if (clazz.equals(StorageAdapter.class)) {
            return (T)this.asStorageAdapter();
        }
        return null;
    }

    default public boolean isTombstone() {
        return false;
    }

    default public String asString() {
        return this.getClass().toString();
    }
}

