/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;

public class SimpleDescendingOffset
extends SimpleSettableOffset {
    private final int rowCount;
    private final int initialOffset;
    private int currentOffset;

    public SimpleDescendingOffset(int rowCount) {
        this(rowCount - 1, rowCount);
    }

    private SimpleDescendingOffset(int initialOffset, int rowCount) {
        this.rowCount = rowCount;
        this.initialOffset = initialOffset;
        this.currentOffset = initialOffset;
    }

    @Override
    public void increment() {
        --this.currentOffset;
    }

    @Override
    public boolean withinBounds() {
        return this.currentOffset >= 0;
    }

    @Override
    public void reset() {
        this.currentOffset = this.initialOffset;
    }

    @Override
    public ReadableOffset getBaseReadableOffset() {
        return this;
    }

    @Override
    public Offset clone() {
        return new SimpleDescendingOffset(this.currentOffset, this.rowCount);
    }

    @Override
    public int getOffset() {
        return this.currentOffset;
    }

    @Override
    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    public String toString() {
        return this.currentOffset + "/" + this.rowCount + "(DSC)";
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

