/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.apache.druid.segment.data.ColumnarDoubles;

public class EntireLayoutColumnarDoublesSupplier
implements Supplier<ColumnarDoubles> {
    private final int totalSize;
    private final DoubleBuffer buffer;

    public EntireLayoutColumnarDoublesSupplier(int totalSize, ByteBuffer fromBuffer, ByteOrder byteOrder) {
        this.totalSize = totalSize;
        this.buffer = fromBuffer.asReadOnlyBuffer().order(byteOrder).asDoubleBuffer();
    }

    public ColumnarDoubles get() {
        return new EntireLayoutColumnarDoubles();
    }

    private class EntireLayoutColumnarDoubles
    implements ColumnarDoubles {
        private EntireLayoutColumnarDoubles() {
        }

        @Override
        public int size() {
            return EntireLayoutColumnarDoublesSupplier.this.totalSize;
        }

        @Override
        public double get(int index) {
            return EntireLayoutColumnarDoublesSupplier.this.buffer.get(EntireLayoutColumnarDoublesSupplier.this.buffer.position() + index);
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "EntireLayoutColumnarDoubles{, totalSize=" + EntireLayoutColumnarDoublesSupplier.this.totalSize + "}";
        }
    }
}

