/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.segment.data.CompressionFactory;

public class LongsLongEncodingReader
implements CompressionFactory.LongEncodingReader {
    private Memory buffer;

    public LongsLongEncodingReader(ByteBuffer fromBuffer, ByteOrder order) {
        this.buffer = Memory.wrap((ByteBuffer)fromBuffer.slice(), (ByteOrder)order);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.buffer = Memory.wrap((ByteBuffer)buffer.slice(), (ByteOrder)buffer.order());
    }

    @Override
    public long read(int index) {
        return this.buffer.getLong((long)index << 3);
    }

    @Override
    public void read(long[] out, int outPosition, int startIndex, int length) {
        this.buffer.getLongArray((long)startIndex << 3, out, outPosition, length);
    }

    @Override
    public int read(long[] out, int outPosition, int[] indexes, int length, int indexOffset, int limit) {
        for (int i = 0; i < length; ++i) {
            int index = indexes[outPosition + i] - indexOffset;
            if (index >= limit) {
                return i;
            }
            out[outPosition + i] = this.buffer.getLong((long)index << 3);
        }
        return length;
    }

    @Override
    public CompressionFactory.LongEncodingReader duplicate() {
        return new LongsLongEncodingReader(this.buffer.getByteBuffer(), this.buffer.getTypeByteOrder());
    }

    @Override
    public CompressionFactory.LongEncodingStrategy getStrategy() {
        return CompressionFactory.LongEncodingStrategy.LONGS;
    }
}

