/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class AllUnknownBitmapColumnIndex
implements BitmapColumnIndex {
    private final ColumnIndexSelector selector;

    public AllUnknownBitmapColumnIndex(ColumnIndexSelector indexSelector) {
        this.selector = indexSelector;
    }

    @Override
    public ColumnIndexCapabilities getIndexCapabilities() {
        return SimpleColumnIndexCapabilities.getConstant();
    }

    @Override
    public int estimatedComputeCost() {
        return 0;
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
        if (includeUnknown) {
            return bitmapResultFactory.wrapAllTrue(this.selector.getBitmapFactory().complement(this.selector.getBitmapFactory().makeEmptyImmutableBitmap(), this.selector.getNumRows()));
        }
        return bitmapResultFactory.wrapAllFalse(this.selector.getBitmapFactory().makeEmptyImmutableBitmap());
    }
}

