/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter.rewrite;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.segment.join.JoinableClause;

public class RhsRewriteCandidate {
    private final boolean isDirectRewrite;
    @Nonnull
    private final JoinableClause joinableClause;
    private final String rhsColumn;
    @Nullable
    private final String valueForRewrite;

    public RhsRewriteCandidate(@Nonnull JoinableClause joinableClause, String rhsColumn, @Nullable String valueForRewrite, boolean isDirectRewrite) {
        this.joinableClause = joinableClause;
        this.rhsColumn = rhsColumn;
        this.valueForRewrite = valueForRewrite;
        this.isDirectRewrite = isDirectRewrite;
    }

    @Nonnull
    public JoinableClause getJoinableClause() {
        return this.joinableClause;
    }

    public String getRhsColumn() {
        return this.rhsColumn;
    }

    @Nullable
    public String getValueForRewrite() {
        return this.valueForRewrite;
    }

    public boolean isDirectRewrite() {
        return this.isDirectRewrite;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RhsRewriteCandidate that = (RhsRewriteCandidate)o;
        return this.isDirectRewrite == that.isDirectRewrite && this.joinableClause.equals(that.joinableClause) && Objects.equals(this.rhsColumn, that.rhsColumn) && Objects.equals(this.valueForRewrite, that.valueForRewrite);
    }

    public int hashCode() {
        return Objects.hash(this.isDirectRewrite, this.joinableClause, this.rhsColumn, this.valueForRewrite);
    }
}

