/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.SortedMap;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.Serializer;

public abstract class NestedCommonFormatColumnSerializer
implements GenericColumnSerializer<StructuredData> {
    public static final byte V0 = 0;
    public static final String RAW_FILE_NAME = "__raw";
    public static final String NESTED_FIELD_PREFIX = "__field_";

    public abstract void openDictionaryWriter(File var1) throws IOException;

    public void serializeFields(SortedMap<String, FieldTypeInfo.MutableTypeSet> fields) throws IOException {
    }

    public abstract void serializeDictionaries(Iterable<String> var1, Iterable<Long> var2, Iterable<Double> var3, Iterable<int[]> var4) throws IOException;

    public abstract String getColumnName();

    public abstract DictionaryIdLookup getDictionaryIdLookup();

    public abstract void setDictionaryIdLookup(DictionaryIdLookup var1);

    public abstract boolean hasNulls();

    protected void writeInternal(FileSmoosher smoosher, Serializer serializer, String fileName) throws IOException {
        ColumnSerializerUtils.writeInternal(smoosher, serializer, this.getColumnName(), fileName);
    }

    protected static void copyFromTempSmoosh(FileSmoosher smoosher, SmooshedFileMapper fileMapper) throws IOException {
        for (String internalName : fileMapper.getInternalFilenames()) {
            smoosher.add(internalName, fileMapper.mapFile(internalName));
        }
    }

    public static void writeV0Header(WritableByteChannel channel, ByteBuffer columnNameBuffer) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{0}));
        channel.write(columnNameBuffer);
    }

    protected ByteBuffer computeFilenameBytes() {
        String columnName = this.getColumnName();
        return ColumnSerializerUtils.stringToUtf8InVSizeByteBuffer(columnName);
    }
}

