/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public abstract class BaseDimensionRangeShardSpec
implements ShardSpec {
    protected final List<String> dimensions;
    @Nullable
    protected final StringTuple start;
    @Nullable
    protected final StringTuple end;

    protected BaseDimensionRangeShardSpec(List<String> dimensions, @Nullable StringTuple start, @Nullable StringTuple end) {
        this.dimensions = dimensions;
        this.start = start;
        this.end = end;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return BaseDimensionRangeShardSpec.createLookup(this.dimensions, shardSpecs);
    }

    private static ShardSpecLookup createLookup(List<String> dimensions, List<? extends ShardSpec> shardSpecs) {
        BaseDimensionRangeShardSpec[] rangeShardSpecs = new BaseDimensionRangeShardSpec[shardSpecs.size()];
        for (int i = 0; i < shardSpecs.size(); ++i) {
            rangeShardSpecs[i] = (BaseDimensionRangeShardSpec)shardSpecs.get(i);
        }
        Ordering startComparator = Comparators.naturalNullsFirst();
        Ordering endComparator = Ordering.natural().nullsLast();
        Comparator<BaseDimensionRangeShardSpec> shardSpecComparator = Comparator.comparing(spec -> spec.start, startComparator).thenComparing(spec -> spec.end, endComparator);
        Arrays.sort(rangeShardSpecs, shardSpecComparator);
        return (arg_0, arg_1) -> BaseDimensionRangeShardSpec.lambda$createLookup$2(dimensions, shardSpecs, rangeShardSpecs, startComparator, (Comparator)endComparator, arg_0, arg_1);
    }

    protected static StringTuple getInputRowTuple(List<String> dimensions, InputRow inputRow) {
        String[] inputDimensionValues = new String[dimensions.size()];
        for (int i = 0; i < dimensions.size(); ++i) {
            List<String> values = inputRow.getDimension(dimensions.get(i));
            inputDimensionValues[i] = values != null && values.size() == 1 ? values.get(0) : null;
        }
        return StringTuple.create(inputDimensionValues);
    }

    private static /* synthetic */ ShardSpec lambda$createLookup$2(List dimensions, List shardSpecs, BaseDimensionRangeShardSpec[] rangeShardSpecs, Comparator startComparator, Comparator endComparator, long timestamp, InputRow row) {
        StringTuple inputRowTuple = BaseDimensionRangeShardSpec.getInputRowTuple(dimensions, row);
        int startIndex = 0;
        int endIndex = shardSpecs.size() - 1;
        while (startIndex <= endIndex) {
            int mid = startIndex + endIndex >>> 1;
            BaseDimensionRangeShardSpec rangeShardSpec = rangeShardSpecs[mid];
            if (startComparator.compare(inputRowTuple, rangeShardSpec.start) < 0) {
                endIndex = mid - 1;
                continue;
            }
            if (endComparator.compare(inputRowTuple, rangeShardSpec.end) < 0) {
                return rangeShardSpec;
            }
            startIndex = mid + 1;
        }
        throw new ISE("row[%s] doesn't fit in any shard[%s]", row, shardSpecs);
    }
}

