/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.StringPartitionChunk;

public class SingleDimensionShardSpec
extends DimensionRangeShardSpec {
    public static final int UNKNOWN_NUM_CORE_PARTITIONS = -1;
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;

    @JsonCreator
    public SingleDimensionShardSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end, @JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="numCorePartitions") @Nullable Integer numCorePartitions) {
        super(dimension == null ? Collections.emptyList() : Collections.singletonList(dimension), start == null ? null : StringTuple.create(start), end == null ? null : StringTuple.create(end), partitionNum, numCorePartitions);
        this.dimension = dimension;
        this.start = start;
        this.end = end;
    }

    @JsonValue
    public Map<String, Object> getSerializableObject() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("start", this.start);
        jsonMap.put("end", this.end);
        jsonMap.put("dimension", this.dimension);
        jsonMap.put("partitionNum", this.getPartitionNum());
        jsonMap.put("numCorePartitions", this.getNumCorePartitions());
        return jsonMap;
    }

    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    public String getStart() {
        return this.start;
    }

    @Nullable
    public String getEnd() {
        return this.end;
    }

    private Range<String> getRange() {
        Range range = this.start == null && this.end == null ? Range.all() : (this.start == null ? Range.atMost((Comparable)((Object)this.end)) : (this.end == null ? Range.atLeast((Comparable)((Object)this.start)) : Range.closed((Comparable)((Object)this.start), (Comparable)((Object)this.end))));
        return range;
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        RangeSet<String> rangeSet = domain.get(this.dimension);
        if (rangeSet == null) {
            return true;
        }
        return !rangeSet.subRangeSet(this.getRange()).isEmpty();
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        if (this.isNumCorePartitionsUnknown()) {
            return StringPartitionChunk.makeForSingleDimension(this.start, this.end, this.getPartitionNum(), obj);
        }
        return new NumberedPartitionChunk<T>(this.getPartitionNum(), this.getNumCorePartitions(), obj);
    }

    @Override
    public String getType() {
        return "single";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionShardSpec shardSpec = (SingleDimensionShardSpec)o;
        return this.getPartitionNum() == shardSpec.getPartitionNum() && this.getNumCorePartitions() == shardSpec.getNumCorePartitions() && Objects.equals(this.dimension, shardSpec.dimension) && Objects.equals(this.start, shardSpec.start) && Objects.equals(this.end, shardSpec.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dimension, this.start, this.end, this.getPartitionNum(), this.getNumCorePartitions());
    }

    @Override
    public String toString() {
        return "SingleDimensionShardSpec{dimension='" + this.dimension + "', start='" + this.start + "', end='" + this.end + "', partitionNum=" + this.getPartitionNum() + ", numCorePartitions=" + this.getNumCorePartitions() + "}";
    }
}

