/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.math.BigDecimal;
import java.util.Objects;

public class RelOptSamplingParameters {
    private final boolean bernoulli;
    public final BigDecimal sampleRate;
    private final boolean repeatable;
    private final int repeatableSeed;

    public RelOptSamplingParameters(boolean bernoulli, BigDecimal sampleRate, boolean repeatable, int repeatableSeed) {
        this.bernoulli = bernoulli;
        this.sampleRate = Objects.requireNonNull(sampleRate, "sampleRate");
        this.repeatable = repeatable;
        this.repeatableSeed = repeatableSeed;
    }

    @Deprecated
    public RelOptSamplingParameters(boolean bernoulli, float sampleRate, boolean isRepeatable, int repeatableSeed) {
        this(bernoulli, BigDecimal.valueOf(sampleRate), isRepeatable, repeatableSeed);
    }

    public boolean isBernoulli() {
        return this.bernoulli;
    }

    @Deprecated
    public float getSamplingPercentage() {
        return this.sampleRate.floatValue();
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public int getRepeatableSeed() {
        return this.repeatableSeed;
    }
}

