/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;

public class CreateUser
extends Command {
    protected final String metalake;
    protected final String user;

    public CreateUser(CommandContext context, String metalake, String user) {
        super(context);
        this.metalake = metalake;
        this.user = user;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.addUser(this.user);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (UserAlreadyExistsException err) {
            this.exitWithError("User already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.user + " created");
    }
}

