/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Audit;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class MetalakeAudit
extends AuditCommand {
    protected final String metalake;

    public MetalakeAudit(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        Audit audit = null;
        try (GravitinoClient client = this.buildClient(this.metalake);){
            audit = client.loadMetalake(this.metalake).auditInfo();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.displayAuditInfo(audit);
    }
}

