/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.ModelChange;

public class UpdateModelName
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;
    protected final String name;

    public UpdateModelName(CommandContext context, String metalake, String catalog, String schema, String model, String name) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
        this.name = name;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier modelIdent = NameIdentifier.of(this.schema, this.model);
            GravitinoClient client = this.buildClient(this.metalake);
            ModelChange renameChange = ModelChange.rename(this.name);
            client.loadCatalog(this.catalog).asModelCatalog().alterModel(modelIdent, renameChange);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException err) {
            this.exitWithError("Unknown model name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.model + " name changed.");
    }
}

