/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.gravitino.rest.RESTRequest;

public class ModelVersionLinkRequest
implements RESTRequest {
    @Nullable
    @JsonProperty(value="uri")
    private String uri;
    @Nullable
    @JsonProperty(value="uris")
    private Map<String, String> uris;
    @JsonProperty(value="aliases")
    private String[] aliases;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    public ModelVersionLinkRequest(String uri, String[] aliases, String comment, Map<String, String> properties) {
        this(uri, null, aliases, comment, properties);
    }

    public ModelVersionLinkRequest(Map<String, String> uris, String[] aliases, String comment, Map<String, String> properties) {
        this(null, uris, aliases, comment, properties);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        if (this.aliases != null && this.aliases.length > 0) {
            for (String alias : this.aliases) {
                Preconditions.checkArgument(StringUtils.isNotBlank(alias), "alias must not be null or empty");
                Preconditions.checkArgument(!NumberUtils.isCreatable(alias), "alias must not be a number or a number string");
            }
        }
        if (this.uris == null || this.uris.isEmpty()) {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.uri), "\"uri\" field cannot be empty if uris field is null or empty");
        } else {
            this.uris.forEach((n, u) -> {
                Preconditions.checkArgument(StringUtils.isNotBlank(n), "URI name must not be blank");
                Preconditions.checkArgument(StringUtils.isNotBlank(u), "URI must not be blank");
            });
        }
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    @Nullable
    public Map<String, String> getUris() {
        return this.uris;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "ModelVersionLinkRequest(uri=" + this.getUri() + ", uris=" + String.valueOf(this.getUris()) + ", aliases=" + Arrays.deepToString(this.getAliases()) + ", comment=" + this.getComment() + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelVersionLinkRequest)) {
            return false;
        }
        ModelVersionLinkRequest other = (ModelVersionLinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Map<String, String> this$uris = this.getUris();
        Map<String, String> other$uris = other.getUris();
        if (this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAliases(), other.getAliases())) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelVersionLinkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Map<String, String> $uris = this.getUris();
        result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAliases());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public ModelVersionLinkRequest() {
    }

    public ModelVersionLinkRequest(@Nullable String uri, @Nullable Map<String, String> uris, String[] aliases, String comment, Map<String, String> properties) {
        this.uri = uri;
        this.uris = uris;
        this.aliases = aliases;
        this.comment = comment;
        this.properties = properties;
    }
}

