/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface ModelVersionChange {
    public static final Joiner COMMA_JOINER = Joiner.on(",").skipNulls();

    public static ModelVersionChange updateComment(String newComment) {
        return new UpdateComment(newComment);
    }

    public static ModelVersionChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static ModelVersionChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static ModelVersionChange updateUri(String newUri) {
        return new UpdateUri(newUri);
    }

    public static ModelVersionChange updateUri(String uriName, String newUri) {
        return new UpdateUri(uriName, newUri);
    }

    public static ModelVersionChange addUri(String uriName, String uri) {
        return new AddUri(uriName, uri);
    }

    public static ModelVersionChange removeUri(String uriName) {
        return new RemoveUri(uriName);
    }

    public static ModelVersionChange updateAliases(String[] aliasesToAdd, String[] aliasesToRemove) {
        String[] toAdd = aliasesToAdd == null ? new String[]{} : aliasesToAdd;
        String[] toRemove = aliasesToRemove == null ? new String[]{} : aliasesToRemove;
        return new UpdateAliases(Arrays.stream(toAdd).collect(Collectors.toList()), Arrays.stream(toRemove).collect(Collectors.toList()));
    }

    public static final class UpdateComment
    implements ModelVersionChange {
        private final String newComment;

        public UpdateComment(String newComment) {
            this.newComment = newComment;
        }

        public String newComment() {
            return this.newComment;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UpdateComment)) {
                return false;
            }
            UpdateComment other = (UpdateComment)obj;
            return Objects.equals(this.newComment, other.newComment);
        }

        public int hashCode() {
            return Objects.hash(this.newComment);
        }

        public String toString() {
            return "UpdateComment " + this.newComment;
        }
    }

    public static final class SetProperty
    implements ModelVersionChange {
        private final String property;
        private final String value;

        public SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SetProperty)) {
                return false;
            }
            SetProperty other = (SetProperty)obj;
            return Objects.equals(this.property, other.property) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class RemoveProperty
    implements ModelVersionChange {
        private final String property;

        public RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RemoveProperty)) {
                return false;
            }
            RemoveProperty other = (RemoveProperty)obj;
            return Objects.equals(this.property, other.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }

    public static final class UpdateUri
    implements ModelVersionChange {
        private final String uriName;
        private final String newUri;

        public UpdateUri(String newUri) {
            this("unknown", newUri);
        }

        public UpdateUri(String uriName, String newUri) {
            this.uriName = uriName;
            this.newUri = newUri;
        }

        public String newUri() {
            return this.newUri;
        }

        public String uriName() {
            return this.uriName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UpdateUri)) {
                return false;
            }
            UpdateUri other = (UpdateUri)obj;
            return Objects.equals(this.newUri, other.newUri) && Objects.equals(this.uriName, other.uriName);
        }

        public int hashCode() {
            return Objects.hash(this.newUri, this.uriName);
        }

        public String toString() {
            return "UpdateUri uriName: (" + this.uriName + ") newUri: (" + this.newUri + ")";
        }
    }

    public static final class AddUri
    implements ModelVersionChange {
        private final String uriName;
        private final String uri;

        public AddUri(String uriName, String uri) {
            this.uriName = uriName;
            this.uri = uri;
        }

        public String uri() {
            return this.uri;
        }

        public String uriName() {
            return this.uriName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AddUri)) {
                return false;
            }
            AddUri other = (AddUri)obj;
            return Objects.equals(this.uri, other.uri) && Objects.equals(this.uriName, other.uriName);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.uriName);
        }

        public String toString() {
            return "AddUri uriName: (" + this.uriName + ") uri: (" + this.uri + ")";
        }
    }

    public static final class RemoveUri
    implements ModelVersionChange {
        private final String uriName;

        public RemoveUri(String uriName) {
            this.uriName = uriName;
        }

        public String uriName() {
            return this.uriName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RemoveUri)) {
                return false;
            }
            RemoveUri other = (RemoveUri)obj;
            return Objects.equals(this.uriName, other.uriName);
        }

        public int hashCode() {
            return Objects.hash(this.uriName);
        }

        public String toString() {
            return "RemoveUri uriName: (" + this.uriName + ")";
        }
    }

    public static final class UpdateAliases
    implements ModelVersionChange {
        private final ImmutableSortedSet<String> aliasesToAdd;
        private final ImmutableSortedSet<String> aliasesToRemove;

        public UpdateAliases(List<String> aliasesToAdd, List<String> aliasesToRemove) {
            this.aliasesToAdd = ImmutableSortedSet.copyOf(aliasesToAdd != null ? aliasesToAdd : Lists.newArrayList());
            this.aliasesToRemove = ImmutableSortedSet.copyOf(aliasesToRemove != null ? aliasesToRemove : Lists.newArrayList());
        }

        public Set<String> aliasesToAdd() {
            return this.aliasesToAdd;
        }

        public Set<String> aliasesToRemove() {
            return this.aliasesToRemove;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateAliases)) {
                return false;
            }
            UpdateAliases that = (UpdateAliases)o;
            return this.aliasesToAdd.equals(that.aliasesToAdd) && this.aliasesToRemove.equals(that.aliasesToRemove);
        }

        public int hashCode() {
            return Objects.hash(this.aliasesToAdd, this.aliasesToRemove);
        }

        public String toString() {
            return "UpdateAlias AliasToAdd: (" + COMMA_JOINER.join(this.aliasesToAdd) + ") AliasToRemove: (" + COMMA_JOINER.join(this.aliasesToRemove) + ")";
        }
    }
}

