/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.doris;

import java.util.Map;
import org.apache.gravitino.catalog.doris.DorisCatalogCapability;
import org.apache.gravitino.catalog.doris.DorisTablePropertiesMetadata;
import org.apache.gravitino.catalog.doris.converter.DorisColumnDefaultValueConverter;
import org.apache.gravitino.catalog.doris.converter.DorisExceptionConverter;
import org.apache.gravitino.catalog.doris.converter.DorisTypeConverter;
import org.apache.gravitino.catalog.doris.operation.DorisDatabaseOperations;
import org.apache.gravitino.catalog.doris.operation.DorisTableOperations;
import org.apache.gravitino.catalog.jdbc.JdbcCatalog;
import org.apache.gravitino.catalog.jdbc.MySQLProtocolCompatibleCatalogOperations;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.capability.Capability;

public class DorisCatalog
extends JdbcCatalog {
    public static final DorisTablePropertiesMetadata DORIS_TABLE_PROPERTIES_META = new DorisTablePropertiesMetadata();

    public String shortName() {
        return "jdbc-doris";
    }

    protected CatalogOperations newOps(Map<String, String> config) {
        JdbcTypeConverter jdbcTypeConverter = this.createJdbcTypeConverter();
        return new MySQLProtocolCompatibleCatalogOperations(this.createExceptionConverter(), jdbcTypeConverter, this.createJdbcDatabaseOperations(), this.createJdbcTableOperations(), this.createJdbcColumnDefaultValueConverter());
    }

    public Capability newCapability() {
        return new DorisCatalogCapability();
    }

    protected JdbcExceptionConverter createExceptionConverter() {
        return new DorisExceptionConverter();
    }

    protected JdbcTypeConverter createJdbcTypeConverter() {
        return new DorisTypeConverter();
    }

    protected JdbcDatabaseOperations createJdbcDatabaseOperations() {
        return new DorisDatabaseOperations();
    }

    protected JdbcTableOperations createJdbcTableOperations() {
        return new DorisTableOperations();
    }

    protected JdbcColumnDefaultValueConverter createJdbcColumnDefaultValueConverter() {
        return new DorisColumnDefaultValueConverter();
    }

    public PropertiesMetadata tablePropertiesMetadata() throws UnsupportedOperationException {
        return DORIS_TABLE_PROPERTIES_META;
    }
}

