/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class PolicyVersionPO {
    private Long id;
    private Long metalakeId;
    private Long policyId;
    private Long version;
    private String policyComment;
    private boolean enabled;
    private String content;
    private Long deletedAt;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyVersionPO)) {
            return false;
        }
        PolicyVersionPO that = (PolicyVersionPO)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.metalakeId, (Object)that.metalakeId) && Objects.equal((Object)this.policyId, (Object)that.policyId) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.policyComment, (Object)that.policyComment) && Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)this.content, (Object)that.content) && Objects.equal((Object)this.deletedAt, (Object)that.deletedAt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.metalakeId, this.policyId, this.version, this.policyComment, this.enabled, this.content, this.deletedAt});
    }

    public Long getId() {
        return this.id;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getPolicyId() {
        return this.policyId;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getPolicyComment() {
        return this.policyComment;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getContent() {
        return this.content;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private Long id;
        private Long metalakeId;
        private Long policyId;
        private Long version;
        private String policyComment;
        private boolean enabled;
        private String content;
        private Long deletedAt;

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.metalakeId = metalakeId;
            return this;
        }

        public Builder withPolicyId(Long policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public Builder withPolicyComment(String policyComment) {
            this.policyComment = policyComment;
            return this;
        }

        public Builder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public PolicyVersionPO build() {
            this.validate();
            PolicyVersionPO policyVersionPO = new PolicyVersionPO();
            policyVersionPO.id = this.id;
            policyVersionPO.metalakeId = this.metalakeId;
            policyVersionPO.policyId = this.policyId;
            policyVersionPO.version = this.version;
            policyVersionPO.policyComment = this.policyComment;
            policyVersionPO.enabled = this.enabled;
            policyVersionPO.content = this.content;
            policyVersionPO.deletedAt = this.deletedAt;
            return policyVersionPO;
        }

        private void validate() {
            Preconditions.checkArgument((this.metalakeId != null ? 1 : 0) != 0, (Object)"metalakeId is required");
            Preconditions.checkArgument((this.policyId != null ? 1 : 0) != 0, (Object)"policyId is required");
            Preconditions.checkArgument((this.version != null ? 1 : 0) != 0, (Object)"version is required");
            Preconditions.checkArgument((this.content != null ? 1 : 0) != 0, (Object)"content is required");
            Preconditions.checkArgument((this.deletedAt != null ? 1 : 0) != 0, (Object)"deletedAt is required");
        }
    }
}

