/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import org.apache.gravitino.Config;
import org.apache.gravitino.server.authentication.OAuthConfig;
import org.apache.gravitino.server.authentication.OAuthTokenValidator;

public class OAuthTokenValidatorFactory {
    public static OAuthTokenValidator createValidator(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        String validatorClass = (String)config.get(OAuthConfig.TOKEN_VALIDATOR_CLASS);
        OAuthTokenValidator validator = OAuthTokenValidatorFactory.createValidatorFromClass(validatorClass);
        validator.initialize(config);
        return validator;
    }

    private static OAuthTokenValidator createValidatorFromClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!OAuthTokenValidator.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + className + " does not implement OAuthTokenValidator");
            }
            return (OAuthTokenValidator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create validator instance from class: " + className, e);
        }
    }
}

