/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.job.JobHandle;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.JobEntity;

public class JobPO {
    private Long jobRunId;
    private String jobTemplateName;
    private Long metalakeId;
    private String jobExecutionId;
    private String jobRunStatus;
    private Long jobFinishedAt;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public JobPO() {
    }

    private JobPO(Long jobRunId, String jobTemplateName, Long metalakeId, String jobExecutionId, String jobRunStatus, Long jobFinishedAt, String auditInfo, Long currentVersion, Long lastVersion, Long deletedAt) {
        Preconditions.checkArgument((jobRunId != null ? 1 : 0) != 0, (Object)"jobRunId cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jobTemplateName), (Object)"jobTemplateName cannot be blank");
        Preconditions.checkArgument((metalakeId != null ? 1 : 0) != 0, (Object)"metalakeId cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jobExecutionId), (Object)"jobExecutionId cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jobRunStatus), (Object)"jobRunStatus cannot be blank");
        Preconditions.checkArgument((jobFinishedAt != null ? 1 : 0) != 0, (Object)"jobFinishedAt cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)auditInfo), (Object)"auditInfo cannot be blank");
        Preconditions.checkArgument((currentVersion != null ? 1 : 0) != 0, (Object)"currentVersion cannot be null");
        Preconditions.checkArgument((lastVersion != null ? 1 : 0) != 0, (Object)"lastVersion cannot be null");
        Preconditions.checkArgument((deletedAt != null ? 1 : 0) != 0, (Object)"deletedAt cannot be null");
        this.jobRunId = jobRunId;
        this.jobTemplateName = jobTemplateName;
        this.metalakeId = metalakeId;
        this.jobExecutionId = jobExecutionId;
        this.jobRunStatus = jobRunStatus;
        this.jobFinishedAt = jobFinishedAt;
        this.auditInfo = auditInfo;
        this.currentVersion = currentVersion;
        this.lastVersion = lastVersion;
        this.deletedAt = deletedAt;
    }

    public static JobPO initializeJobPO(JobEntity jobEntity, JobPOBuilder builder) {
        long finished = 0L;
        if (jobEntity.status() == JobHandle.Status.CANCELLED || jobEntity.status() == JobHandle.Status.FAILED || jobEntity.status() == JobHandle.Status.SUCCEEDED) {
            finished = System.currentTimeMillis();
        }
        try {
            return builder.withJobRunId(jobEntity.id()).withJobTemplateName(jobEntity.jobTemplateName()).withJobExecutionId(jobEntity.jobExecutionId()).withJobRunStatus(jobEntity.status().name()).withJobFinishedAt(finished).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)jobEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize job entity", e);
        }
    }

    public static JobEntity fromJobPO(JobPO jobPO, Namespace namespace) {
        try {
            return JobEntity.builder().withId(jobPO.jobRunId).withJobExecutionId(jobPO.jobExecutionId).withNamespace(namespace).withStatus(JobHandle.Status.valueOf((String)jobPO.jobRunStatus)).withJobTemplateName(jobPO.jobTemplateName).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(jobPO.auditInfo, AuditInfo.class)).withFinishedAt(jobPO.jobFinishedAt()).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize job PO", e);
        }
    }

    public static JobPOBuilder builder() {
        return new JobPOBuilder();
    }

    public Long jobRunId() {
        return this.jobRunId;
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public Long metalakeId() {
        return this.metalakeId;
    }

    public String jobExecutionId() {
        return this.jobExecutionId;
    }

    public String jobRunStatus() {
        return this.jobRunStatus;
    }

    public Long jobFinishedAt() {
        return this.jobFinishedAt;
    }

    public String auditInfo() {
        return this.auditInfo;
    }

    public Long currentVersion() {
        return this.currentVersion;
    }

    public Long lastVersion() {
        return this.lastVersion;
    }

    public Long deletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobPO)) {
            return false;
        }
        JobPO other = (JobPO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$jobRunId = this.jobRunId();
        Long other$jobRunId = other.jobRunId();
        if (this$jobRunId == null ? other$jobRunId != null : !((Object)this$jobRunId).equals(other$jobRunId)) {
            return false;
        }
        Long this$metalakeId = this.metalakeId();
        Long other$metalakeId = other.metalakeId();
        if (this$metalakeId == null ? other$metalakeId != null : !((Object)this$metalakeId).equals(other$metalakeId)) {
            return false;
        }
        Long this$jobFinishedAt = this.jobFinishedAt();
        Long other$jobFinishedAt = other.jobFinishedAt();
        if (this$jobFinishedAt == null ? other$jobFinishedAt != null : !((Object)this$jobFinishedAt).equals(other$jobFinishedAt)) {
            return false;
        }
        Long this$currentVersion = this.currentVersion();
        Long other$currentVersion = other.currentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !((Object)this$currentVersion).equals(other$currentVersion)) {
            return false;
        }
        Long this$lastVersion = this.lastVersion();
        Long other$lastVersion = other.lastVersion();
        if (this$lastVersion == null ? other$lastVersion != null : !((Object)this$lastVersion).equals(other$lastVersion)) {
            return false;
        }
        Long this$deletedAt = this.deletedAt();
        Long other$deletedAt = other.deletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        String this$jobTemplateName = this.jobTemplateName();
        String other$jobTemplateName = other.jobTemplateName();
        if (this$jobTemplateName == null ? other$jobTemplateName != null : !this$jobTemplateName.equals(other$jobTemplateName)) {
            return false;
        }
        String this$jobExecutionId = this.jobExecutionId();
        String other$jobExecutionId = other.jobExecutionId();
        if (this$jobExecutionId == null ? other$jobExecutionId != null : !this$jobExecutionId.equals(other$jobExecutionId)) {
            return false;
        }
        String this$jobRunStatus = this.jobRunStatus();
        String other$jobRunStatus = other.jobRunStatus();
        if (this$jobRunStatus == null ? other$jobRunStatus != null : !this$jobRunStatus.equals(other$jobRunStatus)) {
            return false;
        }
        String this$auditInfo = this.auditInfo();
        String other$auditInfo = other.auditInfo();
        return !(this$auditInfo == null ? other$auditInfo != null : !this$auditInfo.equals(other$auditInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobPO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $jobRunId = this.jobRunId();
        result = result * 59 + ($jobRunId == null ? 43 : ((Object)$jobRunId).hashCode());
        Long $metalakeId = this.metalakeId();
        result = result * 59 + ($metalakeId == null ? 43 : ((Object)$metalakeId).hashCode());
        Long $jobFinishedAt = this.jobFinishedAt();
        result = result * 59 + ($jobFinishedAt == null ? 43 : ((Object)$jobFinishedAt).hashCode());
        Long $currentVersion = this.currentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : ((Object)$currentVersion).hashCode());
        Long $lastVersion = this.lastVersion();
        result = result * 59 + ($lastVersion == null ? 43 : ((Object)$lastVersion).hashCode());
        Long $deletedAt = this.deletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        String $jobTemplateName = this.jobTemplateName();
        result = result * 59 + ($jobTemplateName == null ? 43 : $jobTemplateName.hashCode());
        String $jobExecutionId = this.jobExecutionId();
        result = result * 59 + ($jobExecutionId == null ? 43 : $jobExecutionId.hashCode());
        String $jobRunStatus = this.jobRunStatus();
        result = result * 59 + ($jobRunStatus == null ? 43 : $jobRunStatus.hashCode());
        String $auditInfo = this.auditInfo();
        result = result * 59 + ($auditInfo == null ? 43 : $auditInfo.hashCode());
        return result;
    }

    public String toString() {
        return "JobPO(jobRunId=" + this.jobRunId() + ", jobTemplateName=" + this.jobTemplateName() + ", metalakeId=" + this.metalakeId() + ", jobExecutionId=" + this.jobExecutionId() + ", jobRunStatus=" + this.jobRunStatus() + ", jobFinishedAt=" + this.jobFinishedAt() + ", auditInfo=" + this.auditInfo() + ", currentVersion=" + this.currentVersion() + ", lastVersion=" + this.lastVersion() + ", deletedAt=" + this.deletedAt() + ")";
    }

    public static class JobPOBuilder {
        private Long jobRunId;
        private String jobTemplateName;
        private Long metalakeId;
        private String jobExecutionId;
        private String jobRunStatus;
        private Long jobFinishedAt;
        private String auditInfo;
        private Long currentVersion;
        private Long lastVersion;
        private Long deletedAt;

        JobPOBuilder() {
        }

        public JobPOBuilder withJobRunId(Long jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public JobPOBuilder withJobTemplateName(String jobTemplateName) {
            this.jobTemplateName = jobTemplateName;
            return this;
        }

        public JobPOBuilder withMetalakeId(Long metalakeId) {
            this.metalakeId = metalakeId;
            return this;
        }

        public JobPOBuilder withJobExecutionId(String jobExecutionId) {
            this.jobExecutionId = jobExecutionId;
            return this;
        }

        public JobPOBuilder withJobRunStatus(String jobRunStatus) {
            this.jobRunStatus = jobRunStatus;
            return this;
        }

        public JobPOBuilder withJobFinishedAt(Long jobFinishedAt) {
            this.jobFinishedAt = jobFinishedAt;
            return this;
        }

        public JobPOBuilder withAuditInfo(String auditInfo) {
            this.auditInfo = auditInfo;
            return this;
        }

        public JobPOBuilder withCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public JobPOBuilder withLastVersion(Long lastVersion) {
            this.lastVersion = lastVersion;
            return this;
        }

        public JobPOBuilder withDeletedAt(Long deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public JobPO build() {
            return new JobPO(this.jobRunId, this.jobTemplateName, this.metalakeId, this.jobExecutionId, this.jobRunStatus, this.jobFinishedAt, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt);
        }

        public String toString() {
            return "JobPO.JobPOBuilder(jobRunId=" + this.jobRunId + ", jobTemplateName=" + this.jobTemplateName + ", metalakeId=" + this.metalakeId + ", jobExecutionId=" + this.jobExecutionId + ", jobRunStatus=" + this.jobRunStatus + ", jobFinishedAt=" + this.jobFinishedAt + ", auditInfo=" + this.auditInfo + ", currentVersion=" + this.currentVersion + ", lastVersion=" + this.lastVersion + ", deletedAt=" + this.deletedAt + ")";
        }
    }
}

