/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions.sorts;

import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;

@Evolving
public enum SortDirection {
    ASCENDING(NullOrdering.NULLS_FIRST),
    DESCENDING(NullOrdering.NULLS_LAST);

    private final NullOrdering defaultNullOrdering;

    private SortDirection(NullOrdering defaultNullOrdering) {
        this.defaultNullOrdering = defaultNullOrdering;
    }

    public NullOrdering defaultNullOrdering() {
        return this.defaultNullOrdering;
    }

    public String toString() {
        switch (this) {
            case ASCENDING: {
                return "asc";
            }
            case DESCENDING: {
                return "desc";
            }
        }
        throw new IllegalArgumentException("Unexpected sort direction: " + String.valueOf((Object)this));
    }

    public static SortDirection fromString(String str) {
        switch (str.toLowerCase()) {
            case "asc": {
                return ASCENDING;
            }
            case "desc": {
                return DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unexpected sort direction: " + str);
    }
}

