/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.po.ModelVersionAliasRelPO;
import org.apache.gravitino.storage.relational.po.ModelVersionPO;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.service.ModelMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;

public class ModelVersionMetaService {
    private static final ModelVersionMetaService INSTANCE = new ModelVersionMetaService();

    public static ModelVersionMetaService getInstance() {
        return INSTANCE;
    }

    private ModelVersionMetaService() {
    }

    public List<ModelVersionEntity> listModelVersionsByNamespace(Namespace ns) {
        NamespaceUtil.checkModelVersion(ns);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ns.levels());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        List modelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.listModelVersionMetasByModelId(modelEntity.id()));
        if (modelVersionPOs.isEmpty()) {
            return Collections.emptyList();
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.selectModelVersionAliasRelsByModelId(modelEntity.id()));
        ArrayListMultimap aliasRelPOsByModelVersion = ArrayListMultimap.create();
        aliasRelPOs.forEach(arg_0 -> ModelVersionMetaService.lambda$listModelVersionsByNamespace$2((Multimap)aliasRelPOsByModelVersion, arg_0));
        return ImmutableList.copyOf(modelVersionPOs.stream().collect(Collectors.groupingBy(ModelVersionPO::getModelVersion, Collectors.collectingAndThen(Collectors.toList(), arg_0 -> ModelVersionMetaService.lambda$listModelVersionsByNamespace$3((Multimap)aliasRelPOsByModelVersion, modelIdent, arg_0)))).values());
    }

    public ModelVersionEntity getModelVersionByIdentifier(NameIdentifier ident) {
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        List modelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionMeta(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionMetaByAlias(modelEntity.id(), ident.name());
        });
        if (modelVersionPOs.isEmpty()) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL_VERSION.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
        });
        return POConverters.fromModelVersionPO(modelIdent, modelVersionPOs, aliasRelPOs);
    }

    public void insertModelVersion(ModelVersionEntity modelVersionEntity) throws IOException {
        NameIdentifier modelIdent = modelVersionEntity.modelIdentifier();
        NameIdentifierUtil.checkModel(modelIdent);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(modelIdent.namespace());
        Long modelId = ModelMetaService.getInstance().getModelIdBySchemaIdAndModelName(schemaId, modelIdent.name());
        List<ModelVersionPO> modelVersionPOs = POConverters.initializeModelVersionPO(modelVersionEntity, modelId);
        List<ModelVersionAliasRelPO> aliasRelPOs = POConverters.initializeModelVersionAliasRelPO(modelVersionEntity, modelId);
        try {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.insertModelVersionMetas(modelVersionPOs)), () -> {
                if (aliasRelPOs.isEmpty()) {
                    return;
                }
                SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.insertModelVersionAliasRels(aliasRelPOs));
            }, () -> SessionUtils.doWithoutCommit(ModelMetaMapper.class, mapper -> mapper.updateModelLatestVersion(modelId)));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL_VERSION, modelVersionEntity.modelIdentifier().toString());
            throw re;
        }
    }

    public boolean deleteModelVersion(NameIdentifier ident) {
        ModelEntity modelEntity;
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        try {
            modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        }
        catch (NoSuchEntityException e) {
            return false;
        }
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        AtomicInteger modelVersionDeletedCount = new AtomicInteger();
        SessionUtils.doMultipleWithCommit(() -> modelVersionDeletedCount.set(SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.softDeleteModelVersionMetaByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.softDeleteModelVersionMetaByModelIdAndAlias(modelEntity.id(), ident.name());
        })), () -> {
            if (modelVersionDeletedCount.get() == 0) {
                return;
            }
            SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
                if (isVersionNumber) {
                    mapper.softDeleteModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
                } else {
                    mapper.softDeleteModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
                }
            });
        });
        return modelVersionDeletedCount.get() > 0;
    }

    public int deleteModelVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        int[] modelVersionDeletedCount = new int[]{0};
        int[] modelVersionAliasRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            modelVersionDeletedCount[0] = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.deleteModelVersionMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            modelVersionAliasRelDeletedCount[0] = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.deleteModelVersionAliasRelsByLegacyTimeline(legacyTimeline, limit));
        });
        return modelVersionDeletedCount[0] + modelVersionAliasRelDeletedCount[0];
    }

    public <E extends Entity & HasIdentifier> ModelVersionEntity updateModelVersion(NameIdentifier ident, Function<E, E> updater) throws IOException {
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        List oldModelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionMeta(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionMetaByAlias(modelEntity.id(), ident.name());
        });
        if (oldModelVersionPOs.isEmpty()) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL_VERSION.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        List oldAliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
        });
        ModelVersionEntity oldModelVersionEntity = POConverters.fromModelVersionPO(modelIdent, oldModelVersionPOs, oldAliasRelPOs);
        ModelVersionEntity newModelVersionEntity = (ModelVersionEntity)updater.apply(oldModelVersionEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldModelVersionEntity.version(), newModelVersionEntity.version()), (String)"The updated model version: %s should be same with the table entity version before: %s", (Object)newModelVersionEntity.version(), (Object)oldModelVersionEntity.version());
        boolean isAliasChanged = this.isModelVersionAliasUpdated(oldModelVersionEntity, newModelVersionEntity);
        List<ModelVersionAliasRelPO> newAliasRelPOs = POConverters.updateModelVersionAliasRelPO(oldAliasRelPOs, newModelVersionEntity);
        boolean isModelVersionUriUpdated = this.isModelVersionUriUpdated(oldModelVersionEntity, newModelVersionEntity);
        AtomicInteger updateResult = new AtomicInteger(0);
        try {
            SessionUtils.doMultipleWithCommit(() -> {
                if (isModelVersionUriUpdated) {
                    updateResult.addAndGet(SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
                        if (isVersionNumber) {
                            return mapper.softDeleteModelVersionMetaByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
                        }
                        return mapper.softDeleteModelVersionMetaByModelIdAndAlias(modelEntity.id(), ident.name());
                    }));
                    List<ModelVersionPO> modelVersionPOs = POConverters.initializeModelVersionPO(newModelVersionEntity, modelEntity.id());
                    SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.insertModelVersionMetasWithVersionNumber(modelVersionPOs));
                } else {
                    updateResult.addAndGet(SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.updateModelVersionMeta(POConverters.updateModelVersionPO((ModelVersionPO)oldModelVersionPOs.get(0), newModelVersionEntity), (ModelVersionPO)oldModelVersionPOs.get(0))));
                }
            }, () -> {
                if (isAliasChanged) {
                    SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> oldModelVersionEntity.aliases().forEach(alias -> mapper.softDeleteModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), (String)alias)));
                    SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.updateModelVersionAliasRel(newAliasRelPOs));
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.CATALOG, newModelVersionEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult.get() > 0) {
            return newModelVersionEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(ident));
    }

    private boolean isModelVersionAliasUpdated(ModelVersionEntity oldModelVersionEntity, ModelVersionEntity newModelVersionEntity) {
        List<String> oldAliases = oldModelVersionEntity.aliases();
        List<String> newAliases = newModelVersionEntity.aliases();
        if (oldAliases.size() != newAliases.size()) {
            return true;
        }
        return !oldAliases.equals(newAliases);
    }

    private boolean isModelVersionUriUpdated(ModelVersionEntity oldModelVersionEntity, ModelVersionEntity newModelVersionEntity) {
        Map<String, String> newUris;
        Map<String, String> oldUris = oldModelVersionEntity.uris();
        return !oldUris.equals(newUris = newModelVersionEntity.uris());
    }

    private static /* synthetic */ ModelVersionEntity lambda$listModelVersionsByNamespace$3(Multimap aliasRelPOsByModelVersion, NameIdentifier modelIdent, List m) {
        ArrayList versionAliasRelPOs = Lists.newArrayList((Iterable)aliasRelPOsByModelVersion.get((Object)((ModelVersionPO)m.get(0)).getModelVersion()));
        return POConverters.fromModelVersionPO(modelIdent, m, versionAliasRelPOs);
    }

    private static /* synthetic */ void lambda$listModelVersionsByNamespace$2(Multimap aliasRelPOsByModelVersion, ModelVersionAliasRelPO r) {
        aliasRelPOsByModelVersion.put((Object)r.getModelVersion(), (Object)r);
    }
}

