/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceInput;
import org.apache.paimon.memory.MemorySliceOutput;

public class BlockHandle {
    public static final int MAX_ENCODED_LENGTH = 14;
    private final long offset;
    private final int size;

    BlockHandle(long offset, int size) {
        this.offset = offset;
        this.size = size;
    }

    public long offset() {
        return this.offset;
    }

    public int size() {
        return this.size;
    }

    public int getFullBlockSize() {
        return this.size + 5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockHandle that = (BlockHandle)o;
        if (this.size != that.size) {
            return false;
        }
        return this.offset == that.offset;
    }

    public int hashCode() {
        int result = Long.hashCode(this.offset);
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        return "BlockHandle{offset=" + this.offset + ", size=" + this.size + '}';
    }

    public static BlockHandle readBlockHandle(MemorySliceInput sliceInput) {
        long offset = sliceInput.readVarLenLong();
        int size = sliceInput.readVarLenInt();
        return new BlockHandle(offset, size);
    }

    public static MemorySlice writeBlockHandle(BlockHandle blockHandle) {
        MemorySliceOutput sliceOutput = new MemorySliceOutput(14);
        BlockHandle.writeBlockHandleTo(blockHandle, sliceOutput);
        return sliceOutput.toSlice();
    }

    public static void writeBlockHandleTo(BlockHandle blockHandle, MemorySliceOutput sliceOutput) {
        sliceOutput.writeVarLenLong(blockHandle.offset);
        sliceOutput.writeVarLenInt(blockHandle.size);
    }
}

