/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.rel.partitions.Partition;

public interface PartitionDispatcher {
    public String[] listPartitionNames(NameIdentifier var1);

    public Partition[] listPartitions(NameIdentifier var1);

    public Partition getPartition(NameIdentifier var1, String var2) throws NoSuchPartitionException;

    default public boolean partitionExists(NameIdentifier tableIdent, String partitionName) {
        try {
            this.getPartition(tableIdent, partitionName);
            return true;
        }
        catch (NoSuchPartitionException e) {
            return false;
        }
    }

    public Partition addPartition(NameIdentifier var1, Partition var2) throws PartitionAlreadyExistsException;

    public boolean dropPartition(NameIdentifier var1, String var2);

    default public boolean purgePartition(NameIdentifier tableIdent, String partitionName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Partition purging is not supported");
    }
}

