/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.dataset.namespace.resolver;

import io.openlineage.client.OpenLineageConfig;
import io.openlineage.client.dataset.DatasetConfig;
import io.openlineage.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import io.openlineage.client.dataset.namespace.resolver.DatasetNamespaceResolverLoader;
import io.openlineage.client.utils.DatasetIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

public class DatasetNamespaceCombinedResolver {
    private final List<DatasetNamespaceResolver> resolvers;

    public DatasetNamespaceCombinedResolver(OpenLineageConfig config) {
        this.resolvers = config == null || config.getDatasetConfig() == null ? Collections.emptyList() : DatasetNamespaceResolverLoader.loadDatasetNamespaceResolvers(config.getDatasetConfig());
    }

    public DatasetNamespaceCombinedResolver(DatasetConfig config) {
        this.resolvers = config == null ? Collections.emptyList() : DatasetNamespaceResolverLoader.loadDatasetNamespaceResolvers(config);
    }

    public String resolve(String namespace) {
        for (DatasetNamespaceResolver resolver : this.resolvers) {
            String resolved = resolver.resolve(namespace);
            if (resolved.equals(namespace)) continue;
            return resolved;
        }
        return namespace;
    }

    public DatasetIdentifier resolve(DatasetIdentifier identifier) {
        return new DatasetIdentifier(identifier.getName(), this.resolve(identifier.getNamespace()), identifier.getSymlinks());
    }

    public URI resolveHost(URI namespace) {
        String resolvedHost = this.resolve(namespace.getHost());
        if (!resolvedHost.equals(namespace.getHost())) {
            try {
                return new URI(namespace.getScheme(), namespace.getUserInfo(), resolvedHost, namespace.getPort(), namespace.getPath(), namespace.getQuery(), namespace.getFragment());
            }
            catch (URISyntaxException e) {
                return namespace;
            }
        }
        return namespace;
    }
}

