/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.jdbc;

import java.util.Map;
import org.apache.gravitino.authorization.common.AuthorizationProperties;

public class JdbcAuthorizationProperties
extends AuthorizationProperties {
    private static final String CONFIG_PREFIX = "authorization.jdbc.";
    public static final String JDBC_PASSWORD = "authorization.jdbc.password";
    public static final String JDBC_USERNAME = "authorization.jdbc.username";
    public static final String JDBC_URL = "authorization.jdbc.url";
    public static final String JDBC_DRIVER = "authorization.jdbc.driver";

    public JdbcAuthorizationProperties(Map<String, String> properties) {
        super(properties);
    }

    private void check(String key, String errorMsg) {
        if (!this.properties.containsKey(key)) {
            throw new IllegalArgumentException(String.format(errorMsg, key));
        }
    }

    @Override
    public String getPropertiesPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public void validate() {
        String errorMsg = "%s is required";
        this.check(JDBC_URL, errorMsg);
        this.check(JDBC_USERNAME, errorMsg);
        this.check(JDBC_PASSWORD, errorMsg);
        this.check(JDBC_DRIVER, errorMsg);
    }
}

