/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.mysql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.gravitino.catalog.jdbc.JdbcTablePropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

public class MysqlTablePropertiesMetadata
extends JdbcTablePropertiesMetadata {
    public static final String GRAVITINO_ENGINE_KEY = "engine";
    public static final String MYSQL_ENGINE_KEY = "ENGINE";
    public static final String GRAVITINO_AUTO_INCREMENT_OFFSET_KEY = "auto-increment-offset";
    public static final String MYSQL_AUTO_INCREMENT_OFFSET_KEY = "AUTO_INCREMENT";
    private static final Map<String, PropertyEntry<?>> PROPERTIES_METADATA = MysqlTablePropertiesMetadata.createPropertiesMetadata();
    public static final BidiMap<String, String> GRAVITINO_CONFIG_TO_MYSQL = MysqlTablePropertiesMetadata.createGravitinoConfigToMysql();

    private static BidiMap<String, String> createGravitinoConfigToMysql() {
        TreeBidiMap map = new TreeBidiMap();
        map.put((Object)GRAVITINO_ENGINE_KEY, (Object)MYSQL_ENGINE_KEY);
        map.put((Object)GRAVITINO_AUTO_INCREMENT_OFFSET_KEY, (Object)MYSQL_AUTO_INCREMENT_OFFSET_KEY);
        return map;
    }

    private static Map<String, PropertyEntry<?>> createPropertiesMetadata() {
        HashMap<String, PropertyEntry> map = new HashMap<String, PropertyEntry>();
        map.put("comment", PropertyEntry.stringReservedPropertyEntry((String)"comment", (String)"The table comment", (boolean)true));
        map.put(GRAVITINO_ENGINE_KEY, PropertyEntry.enumImmutablePropertyEntry((String)GRAVITINO_ENGINE_KEY, (String)"The table engine", (boolean)false, ENGINE.class, (Enum)ENGINE.INNODB, (boolean)false, (boolean)false));
        map.put(GRAVITINO_AUTO_INCREMENT_OFFSET_KEY, PropertyEntry.integerOptionalPropertyEntry((String)GRAVITINO_AUTO_INCREMENT_OFFSET_KEY, (String)"The table auto increment offset", (boolean)true, null, (boolean)false));
        return Collections.unmodifiableMap(map);
    }

    protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
        return PROPERTIES_METADATA;
    }

    public Map<String, String> transformToJdbcProperties(final Map<String, String> properties) {
        return Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                properties.forEach((key, value) -> {
                    if (GRAVITINO_CONFIG_TO_MYSQL.containsKey(key)) {
                        this.put((String)GRAVITINO_CONFIG_TO_MYSQL.get(key), value);
                    }
                });
            }
        });
    }

    public Map<String, String> convertFromJdbcProperties(final Map<String, String> properties) {
        final BidiMap mysqlConfigToGravitino = GRAVITINO_CONFIG_TO_MYSQL.inverseBidiMap();
        return Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                properties.forEach((key, value) -> {
                    if (mysqlConfigToGravitino.containsKey(key)) {
                        this.put((String)mysqlConfigToGravitino.get(key), value);
                    }
                });
            }
        });
    }

    public static enum ENGINE {
        NDBCLUSTER("ndbcluster"),
        FEDERATED("FEDERATED"),
        MEMORY("MEMORY"),
        INNODB("InnoDB"),
        PERFORMANCE_SCHEMA("PERFORMANCE_SCHEMA"),
        MYISAM("MyISAM"),
        NDBINFO("ndbinfo"),
        MRG_MYISAM("MRG_MYISAM"),
        BLACKHOLE("BLACKHOLE"),
        CSV("CSV"),
        ARCHIVE("ARCHIVE");

        private final String value;

        private ENGINE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

