/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage.auth;

import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.TokenProvider;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import org.apache.gravitino.lineage.auth.LineageServerAuthenticationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApiKeyAuthStrategy
implements LineageServerAuthenticationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ApiKeyAuthStrategy.class);

    ApiKeyAuthStrategy() {
    }

    @Override
    public HttpConfig configureHttpConfig(String url, Map<String, String> configs) {
        final String apiKey = configs.get("apiKey");
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new BadRequestException("API key is required when auth type is apiKey");
        }
        HttpConfig config = new HttpConfig();
        config.setUrl(URI.create(url));
        TokenProvider tokenProvider = new TokenProvider(){

            public String getToken() {
                return apiKey;
            }
        };
        config.setAuth(tokenProvider);
        LOG.info("Configured API key authentication for OpenLineage client");
        return config;
    }
}

