/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;

public final class ParquetReadState {
    private static final RowRange MAX_ROW_RANGE = new RowRange(Long.MIN_VALUE, Long.MAX_VALUE);
    private static final RowRange END_ROW_RANGE = new RowRange(Long.MAX_VALUE, Long.MIN_VALUE);
    private final Iterator<RowRange> rowRanges;
    private RowRange currentRange;
    final int maxRepetitionLevel;
    final int maxDefinitionLevel;
    final boolean isRequired;
    long rowId;
    int valueOffset;
    int levelOffset;
    int valuesToReadInPage;
    int rowsToReadInBatch;
    boolean lastListCompleted;
    int numBatchedDefLevels;
    boolean shouldSkip;

    ParquetReadState(ColumnDescriptor descriptor, boolean isRequired, PrimitiveIterator.OfLong rowIndexes) {
        this.maxRepetitionLevel = descriptor.getMaxRepetitionLevel();
        this.maxDefinitionLevel = descriptor.getMaxDefinitionLevel();
        this.isRequired = isRequired;
        this.rowRanges = this.constructRanges(rowIndexes);
        this.nextRange();
    }

    private Iterator<RowRange> constructRanges(PrimitiveIterator.OfLong rowIndexes) {
        if (rowIndexes == null) {
            return null;
        }
        ArrayList<RowRange> rowRanges = new ArrayList<RowRange>();
        long currentStart = Long.MIN_VALUE;
        long previous = Long.MIN_VALUE;
        while (rowIndexes.hasNext()) {
            long idx = rowIndexes.nextLong();
            if (currentStart == Long.MIN_VALUE) {
                currentStart = idx;
            } else if (previous + 1L != idx) {
                RowRange range = new RowRange(currentStart, previous);
                rowRanges.add(range);
                currentStart = idx;
            }
            previous = idx;
        }
        if (previous != Long.MIN_VALUE) {
            rowRanges.add(new RowRange(currentStart, previous));
        }
        return rowRanges.iterator();
    }

    void resetForNewBatch(int batchSize) {
        this.valueOffset = 0;
        this.levelOffset = 0;
        this.rowsToReadInBatch = batchSize;
        this.lastListCompleted = this.maxRepetitionLevel == 0;
        this.numBatchedDefLevels = 0;
        this.shouldSkip = false;
    }

    void resetForNewPage(int totalValuesInPage, long pageFirstRowIndex) {
        this.valuesToReadInPage = totalValuesInPage;
        this.rowId = pageFirstRowIndex;
    }

    long currentRangeStart() {
        return this.currentRange.start;
    }

    long currentRangeEnd() {
        return this.currentRange.end;
    }

    void nextRange() {
        this.currentRange = this.rowRanges == null ? MAX_ROW_RANGE : (!this.rowRanges.hasNext() ? END_ROW_RANGE : this.rowRanges.next());
    }

    private static class RowRange {
        private final long start;
        private final long end;

        public RowRange(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

