/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.shade.org.apache.parquet.column.ParquetProperties;
import org.apache.paimon.shade.org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.paimon.shade.org.apache.parquet.hadoop.CodecFactory;
import org.apache.paimon.shade.org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.paimon.shade.org.apache.parquet.io.OutputFile;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;

public class ParquetWriter<T>
implements Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 0x8000000;
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final CompressionCodecName DEFAULT_COMPRESSION_CODEC_NAME = CompressionCodecName.UNCOMPRESSED;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    public static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.DEFAULT_WRITER_VERSION;
    public static final String OBJECT_MODEL_NAME_PROP = "writer.model.name";
    public static final int MAX_PADDING_SIZE_DEFAULT = 0x800000;
    private final InternalParquetRecordWriter<T> writer;
    private final CodecFactory codecFactory;

    ParquetWriter(OutputFile file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, long rowGroupSize, boolean validating, Configuration conf, int maxPaddingSize, ParquetProperties encodingProps) throws IOException {
        Map<String, String> extraMetadata;
        WriteSupport.WriteContext writeContext = writeSupport.init(conf);
        MessageType schema = writeContext.getSchema();
        ParquetFileWriter fileWriter = new ParquetFileWriter(file, schema, mode, rowGroupSize, maxPaddingSize, encodingProps.getColumnIndexTruncateLength(), encodingProps.getStatisticsTruncateLength(), encodingProps.getPageWriteChecksumEnabled(), (FileEncryptionProperties)null);
        fileWriter.start();
        this.codecFactory = new CodecFactory(conf, encodingProps.getPageSizeThreshold());
        CodecFactory.BytesCompressor compressor = this.codecFactory.getCompressor(compressionCodecName);
        if (encodingProps.getExtraMetaData() == null || encodingProps.getExtraMetaData().isEmpty()) {
            extraMetadata = writeContext.getExtraMetaData();
        } else {
            extraMetadata = new HashMap<String, String>(writeContext.getExtraMetaData());
            encodingProps.getExtraMetaData().forEach((metadataKey, metadataValue) -> {
                if (metadataKey.equals(OBJECT_MODEL_NAME_PROP)) {
                    throw new IllegalArgumentException("Cannot overwrite metadata key writer.model.name. Please use another key name.");
                }
                if (extraMetadata.put((String)metadataKey, (String)metadataValue) != null) {
                    throw new IllegalArgumentException("Duplicate metadata key " + metadataKey + ". Please use another key name.");
                }
            });
        }
        this.writer = new InternalParquetRecordWriter<T>(fileWriter, writeSupport, schema, extraMetadata, rowGroupSize, compressor, validating, encodingProps);
    }

    public void write(T object) throws IOException {
        try {
            this.writer.write(object);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.codecFactory.release();
        }
    }

    public ParquetMetadata getFooter() {
        return this.writer.getFooter();
    }

    public long getDataSize() {
        return this.writer.getDataSize();
    }

    public static abstract class Builder<T, SELF extends Builder<T, SELF>> {
        private final OutputFile file;
        private Configuration conf = new Configuration(false);
        private ParquetFileWriter.Mode mode;
        private CompressionCodecName codecName = DEFAULT_COMPRESSION_CODEC_NAME;
        private long rowGroupSize = 0x8000000L;
        private int maxPaddingSize = 0x800000;
        private boolean enableValidation = false;
        private ParquetProperties.Builder encodingPropsBuilder = ParquetProperties.builder();

        protected Builder(OutputFile path) {
            this.file = path;
        }

        protected abstract SELF self();

        protected abstract WriteSupport<T> getWriteSupport(Configuration var1);

        public SELF withConf(Configuration conf) {
            this.conf = conf;
            return this.self();
        }

        public SELF withWriteMode(ParquetFileWriter.Mode mode) {
            this.mode = mode;
            return this.self();
        }

        public SELF withCompressionCodec(CompressionCodecName codecName) {
            this.codecName = codecName;
            return this.self();
        }

        @Deprecated
        public SELF withRowGroupSize(int rowGroupSize) {
            return this.withRowGroupSize((long)rowGroupSize);
        }

        public SELF withRowGroupSize(long rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
            return this.self();
        }

        public SELF withPageSize(int pageSize) {
            this.encodingPropsBuilder.withPageSize(pageSize);
            return this.self();
        }

        public SELF withPageRowCountLimit(int rowCount) {
            this.encodingPropsBuilder.withPageRowCountLimit(rowCount);
            return this.self();
        }

        public SELF withDictionaryPageSize(int dictionaryPageSize) {
            this.encodingPropsBuilder.withDictionaryPageSize(dictionaryPageSize);
            return this.self();
        }

        public SELF withMaxPaddingSize(int maxPaddingSize) {
            this.maxPaddingSize = maxPaddingSize;
            return this.self();
        }

        public SELF enableDictionaryEncoding() {
            this.encodingPropsBuilder.withDictionaryEncoding(true);
            return this.self();
        }

        public SELF withDictionaryEncoding(boolean enableDictionary) {
            this.encodingPropsBuilder.withDictionaryEncoding(enableDictionary);
            return this.self();
        }

        public SELF withByteStreamSplitEncoding(boolean enableByteStreamSplit) {
            this.encodingPropsBuilder.withByteStreamSplitEncoding(enableByteStreamSplit);
            return this.self();
        }

        public SELF withDictionaryEncoding(String columnPath, boolean enableDictionary) {
            this.encodingPropsBuilder.withDictionaryEncoding(columnPath, enableDictionary);
            return this.self();
        }

        public SELF enableValidation() {
            this.enableValidation = true;
            return this.self();
        }

        public SELF withValidation(boolean enableValidation) {
            this.enableValidation = enableValidation;
            return this.self();
        }

        public SELF withWriterVersion(ParquetProperties.WriterVersion version) {
            this.encodingPropsBuilder.withWriterVersion(version);
            return this.self();
        }

        public SELF enablePageWriteChecksum() {
            this.encodingPropsBuilder.withPageWriteChecksumEnabled(true);
            return this.self();
        }

        public SELF withPageWriteChecksumEnabled(boolean enablePageWriteChecksum) {
            this.encodingPropsBuilder.withPageWriteChecksumEnabled(enablePageWriteChecksum);
            return this.self();
        }

        public SELF withBloomFilterNDV(String columnPath, long ndv) {
            this.encodingPropsBuilder.withBloomFilterNDV(columnPath, ndv);
            return this.self();
        }

        public SELF withBloomFilterFPP(String columnPath, double fpp) {
            this.encodingPropsBuilder.withBloomFilterFPP(columnPath, fpp);
            return this.self();
        }

        public SELF withBloomFilterEnabled(boolean enabled) {
            this.encodingPropsBuilder.withBloomFilterEnabled(enabled);
            return this.self();
        }

        public SELF withBloomFilterEnabled(String columnPath, boolean enabled) {
            this.encodingPropsBuilder.withBloomFilterEnabled(columnPath, enabled);
            return this.self();
        }

        public SELF withMinRowCountForPageSizeCheck(int min) {
            this.encodingPropsBuilder.withMinRowCountForPageSizeCheck(min);
            return this.self();
        }

        public SELF withMaxRowCountForPageSizeCheck(int max) {
            this.encodingPropsBuilder.withMaxRowCountForPageSizeCheck(max);
            return this.self();
        }

        public SELF withColumnIndexTruncateLength(int length) {
            this.encodingPropsBuilder.withColumnIndexTruncateLength(length);
            return this.self();
        }

        public SELF withStatisticsTruncateLength(int length) {
            this.encodingPropsBuilder.withStatisticsTruncateLength(length);
            return this.self();
        }

        public SELF config(String property, String value) {
            this.conf.set(property, value);
            return this.self();
        }

        public ParquetWriter<T> build() throws IOException {
            return new ParquetWriter<T>(this.file, this.mode, this.getWriteSupport(this.conf), this.codecName, this.rowGroupSize, this.enableValidation, this.conf, this.maxPaddingSize, this.encodingPropsBuilder.build());
        }
    }
}

