/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.SnapshotCommit;
import org.apache.paimon.partition.PartitionStatistics;

public class CatalogSnapshotCommit
implements SnapshotCommit {
    private final Catalog catalog;
    private final Identifier identifier;
    @Nullable
    private final String uuid;

    public CatalogSnapshotCommit(Catalog catalog, Identifier identifier, @Nullable String uuid) {
        this.catalog = catalog;
        this.identifier = identifier;
        this.uuid = uuid;
    }

    @Override
    public boolean commit(Snapshot snapshot, String branch, List<PartitionStatistics> statistics) throws Exception {
        Identifier newIdentifier = new Identifier(this.identifier.getDatabaseName(), this.identifier.getTableName(), branch);
        return this.catalog.commitSnapshot(newIdentifier, this.uuid, snapshot, statistics);
    }

    @Override
    public void close() throws Exception {
        this.catalog.close();
    }
}

