/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.operation.CleanOrphanFilesResult;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ThreadPoolUtils;

public class LocalOrphanFilesClean
extends OrphanFilesClean {
    private final ThreadPoolExecutor executor;
    private final List<Path> deleteFiles;
    private final boolean dryRun;
    private final AtomicLong deletedFilesLenInBytes = new AtomicLong(0L);
    private Set<String> candidateDeletes;

    public LocalOrphanFilesClean(FileStoreTable table) {
        this(table, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L));
    }

    public LocalOrphanFilesClean(FileStoreTable table, long olderThanMillis) {
        this(table, olderThanMillis, false);
    }

    public LocalOrphanFilesClean(FileStoreTable table, long olderThanMillis, boolean dryRun) {
        super(table, olderThanMillis, dryRun);
        this.deleteFiles = new ArrayList<Path>();
        this.executor = ThreadPoolUtils.createCachedThreadPool((int)table.coreOptions().deleteFileThreadNum(), (String)"ORPHAN_FILES_CLEAN");
        this.dryRun = dryRun;
    }

    public CleanOrphanFilesResult clean() throws IOException, ExecutionException, InterruptedException {
        List<String> branches = this.validBranches();
        this.cleanSnapshotDir(branches, this.deleteFiles::add, this.deletedFilesLenInBytes::addAndGet);
        Map<String, Pair<Path, Long>> candidates = this.getCandidateDeletingFiles();
        if (candidates.isEmpty()) {
            return new CleanOrphanFilesResult(this.deleteFiles.size(), this.deletedFilesLenInBytes.get(), this.deleteFiles);
        }
        this.candidateDeletes = new HashSet<String>(candidates.keySet());
        Set usedFiles = branches.stream().flatMap(branch -> this.getUsedFiles((String)branch).stream()).collect(Collectors.toSet());
        this.candidateDeletes.removeAll(usedFiles);
        this.candidateDeletes.stream().map(candidates::get).forEach(deleteFileInfo -> {
            this.deletedFilesLenInBytes.addAndGet((Long)deleteFileInfo.getRight());
            this.cleanFile((Path)deleteFileInfo.getLeft());
        });
        this.deleteFiles.addAll(this.candidateDeletes.stream().map(candidates::get).map(Pair::getLeft).collect(Collectors.toList()));
        this.candidateDeletes.clear();
        if (!this.dryRun) {
            this.cleanEmptyDataDirectory(this.deleteFiles);
        }
        return new CleanOrphanFilesResult(this.deleteFiles.size(), this.deletedFilesLenInBytes.get(), this.deleteFiles);
    }

    private void cleanEmptyDataDirectory(List<Path> deleteFiles) {
        if (deleteFiles.isEmpty()) {
            return;
        }
        Set bucketDirs = deleteFiles.stream().map(Path::getParent).filter(path -> path.toUri().toString().contains("bucket-")).collect(Collectors.toSet());
        ThreadPoolUtils.randomlyOnlyExecute((ExecutorService)this.executor, this::tryDeleteEmptyDirectory, bucketDirs);
        Set<Path> partitionDirs = bucketDirs.stream().map(Path::getParent).collect(Collectors.toSet());
        this.tryCleanDataDirectory(partitionDirs, this.partitionKeysNum);
    }

    private void collectWithoutDataFile(String branch, Consumer<String> usedFileConsumer, Consumer<String> manifestConsumer) throws IOException {
        ThreadPoolUtils.randomlyOnlyExecute((ExecutorService)this.executor, snapshot -> {
            try {
                this.collectWithoutDataFile(branch, (Snapshot)snapshot, usedFileConsumer, manifestConsumer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.safelyGetAllSnapshots(branch));
    }

    private Set<String> getUsedFiles(String branch) {
        ConcurrentHashMap.KeySetView usedFiles = ConcurrentHashMap.newKeySet();
        ManifestFile manifestFile = this.table.switchToBranch(branch).store().manifestFileFactory().create();
        try {
            ConcurrentHashMap.KeySetView manifests = ConcurrentHashMap.newKeySet();
            this.collectWithoutDataFile(branch, usedFiles::add, manifests::add);
            ThreadPoolUtils.randomlyOnlyExecute((ExecutorService)this.executor, manifestName -> {
                try {
                    LocalOrphanFilesClean.retryReadingFiles(() -> manifestFile.readWithIOException((String)manifestName), Collections.emptyList()).stream().map(ManifestEntry::file).forEach(f -> {
                        if (this.candidateDeletes.contains(f.fileName())) {
                            usedFiles.add(f.fileName());
                        }
                        f.extraFiles().stream().filter(this.candidateDeletes::contains).forEach(usedFiles::add);
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, manifests);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return usedFiles;
    }

    private Map<String, Pair<Path, Long>> getCandidateDeletingFiles() {
        List<Path> fileDirs = this.listPaimonFileDirs();
        Function<Path, List> processor = path -> this.tryBestListingDirs((Path)path).stream().filter(this::oldEnough).map(status -> Pair.of((Object)status.getPath(), (Object)status.getLen())).collect(Collectors.toList());
        Iterator allFilesInfo = ThreadPoolUtils.randomlyExecuteSequentialReturn((ExecutorService)this.executor, processor, fileDirs);
        HashMap<String, Pair<Path, Long>> result = new HashMap<String, Pair<Path, Long>>();
        while (allFilesInfo.hasNext()) {
            Pair fileInfo = (Pair)allFilesInfo.next();
            result.put(((Path)fileInfo.getLeft()).getName(), (Pair<Path, Long>)fileInfo);
        }
        return result;
    }

    public static List<LocalOrphanFilesClean> createOrphanFilesCleans(Catalog catalog, String databaseName, @Nullable String tableName, long olderThanMillis, final @Nullable Integer parallelism, boolean dryRun) throws Catalog.DatabaseNotExistException, Catalog.TableNotExistException {
        List<String> tableNames = Collections.singletonList(tableName);
        if (tableName == null || "*".equals(tableName)) {
            tableNames = catalog.listTables(databaseName);
        }
        HashMap<String, String> dynamicOptions = parallelism == null ? Collections.emptyMap() : new HashMap<String, String>(){
            {
                this.put(CoreOptions.DELETE_FILE_THREAD_NUM.key(), parallelism.toString());
            }
        };
        ArrayList<LocalOrphanFilesClean> orphanFilesCleans = new ArrayList<LocalOrphanFilesClean>(tableNames.size());
        for (String t : tableNames) {
            Identifier identifier = new Identifier(databaseName, t);
            Table table = catalog.getTable(identifier).copy((Map<String, String>)dynamicOptions);
            Preconditions.checkArgument((boolean)(table instanceof FileStoreTable), (String)"Only FileStoreTable supports remove-orphan-files action. The table type is '%s'.", (Object[])new Object[]{table.getClass().getName()});
            orphanFilesCleans.add(new LocalOrphanFilesClean((FileStoreTable)table, olderThanMillis, dryRun));
        }
        return orphanFilesCleans;
    }

    public static CleanOrphanFilesResult executeDatabaseOrphanFiles(Catalog catalog, String databaseName, @Nullable String tableName, long olderThanMillis, @Nullable Integer parallelism, boolean dryRun) throws Catalog.DatabaseNotExistException, Catalog.TableNotExistException {
        List<LocalOrphanFilesClean> tableCleans = LocalOrphanFilesClean.createOrphanFilesCleans(catalog, databaseName, tableName, olderThanMillis, parallelism, dryRun);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<CleanOrphanFilesResult>> tasks = new ArrayList<Future<CleanOrphanFilesResult>>(tableCleans.size());
        for (LocalOrphanFilesClean clean : tableCleans) {
            tasks.add(executorService.submit(clean::clean));
        }
        long deletedFileCount = 0L;
        long deletedFileTotalLenInBytes = 0L;
        for (Future future : tasks) {
            try {
                deletedFileCount += ((CleanOrphanFilesResult)future.get()).getDeletedFileCount();
                deletedFileTotalLenInBytes += ((CleanOrphanFilesResult)future.get()).getDeletedFileTotalLenInBytes();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        executorService.shutdownNow();
        return new CleanOrphanFilesResult(deletedFileCount, deletedFileTotalLenInBytes);
    }
}

