/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.reader.ReaderSupplier;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableScan;

@Public
public interface TableRead {
    public TableRead withMetricRegistry(MetricRegistry var1);

    public TableRead executeFilter();

    public TableRead withIOManager(IOManager var1);

    public RecordReader<InternalRow> createReader(Split var1) throws IOException;

    default public RecordReader<InternalRow> createReader(List<Split> splits) throws IOException {
        ArrayList<ReaderSupplier> readers = new ArrayList<ReaderSupplier>();
        for (Split split : splits) {
            readers.add(() -> this.createReader(split));
        }
        return ConcatRecordReader.create(readers);
    }

    default public RecordReader<InternalRow> createReader(TableScan.Plan plan) throws IOException {
        return this.createReader(plan.splits());
    }
}

