/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.IntervalDayTime;
import java.util.Objects;

public class TrinoIntervalDayTime
implements Comparable<TrinoIntervalDayTime> {
    private final long milliSeconds;

    public TrinoIntervalDayTime(long milliSeconds) {
        this.milliSeconds = milliSeconds;
    }

    public TrinoIntervalDayTime(int day, int hour, int minute, int second, int millis) {
        this.milliSeconds = IntervalDayTime.toMillis(day, hour, minute, second, millis);
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.milliSeconds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoIntervalDayTime other = (TrinoIntervalDayTime)obj;
        return this.milliSeconds == other.milliSeconds;
    }

    @Override
    public int compareTo(TrinoIntervalDayTime o) {
        return Long.compare(this.milliSeconds, o.milliSeconds);
    }

    public String toString() {
        return IntervalDayTime.formatMillis(this.milliSeconds);
    }
}

