/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.memory;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.gravitino.iceberg.common.cache.SupportsMetadataLocation;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.inmemory.InMemoryCatalog;

public class MemoryCatalogWithMetadataLocationSupport
extends InMemoryCatalog
implements SupportsMetadataLocation {
    private ConcurrentMap<TableIdentifier, String> tableStore;

    public void initialize(String name, Map<String, String> properties) {
        super.initialize(name, properties);
        this.loadFields();
    }

    @Override
    public String metadataLocation(TableIdentifier tableIdentifier) {
        return (String)this.tableStore.get(tableIdentifier);
    }

    private void loadFields() {
        try {
            this.tableStore = (ConcurrentMap)FieldUtils.readField((Object)this, (String)"tables", (boolean)true);
            Preconditions.checkArgument((this.tableStore != null ? 1 : 0) != 0, (Object)"Failed to get tables field from memory catalog");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

