/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import org.apache.gravitino.client.OAuth2ClientUtil;
import org.apache.gravitino.client.OAuth2TokenProvider;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class DefaultOAuth2TokenProvider
extends OAuth2TokenProvider {
    private String credential;
    private String scope;
    private String path;
    private String token;

    private DefaultOAuth2TokenProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getAccessToken() {
        DefaultOAuth2TokenProvider defaultOAuth2TokenProvider = this;
        synchronized (defaultOAuth2TokenProvider) {
            Long expires = OAuth2ClientUtil.expiresAtMillis(this.token);
            if (expires == null || expires <= System.currentTimeMillis()) {
                this.token = OAuth2ClientUtil.fetchToken(this.client, Collections.emptyMap(), this.credential, this.scope, this.path).getAccessToken();
            }
            return this.token;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends OAuth2TokenProvider.OAuth2TokenProviderBuilder<Builder, DefaultOAuth2TokenProvider> {
        private String credential;
        private String scope;
        private String path;

        public Builder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withCredential(String credential) {
            this.credential = credential;
            return this;
        }

        @Override
        protected DefaultOAuth2TokenProvider internalBuild() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.credential), "OAuth2TokenProvider must set credential");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.scope), "OAuth2TokenProvider must set scope");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.path), "OAuth2TokenProvider must set path");
            DefaultOAuth2TokenProvider provider = new DefaultOAuth2TokenProvider();
            provider.client = this.client;
            provider.credential = this.credential;
            provider.scope = this.scope;
            provider.path = this.path;
            provider.token = OAuth2ClientUtil.fetchToken(this.client, Collections.emptyMap(), this.credential, this.scope, this.path).getAccessToken();
            return provider;
        }
    }
}

