/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.restrict.connectiongroup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.restrict.Restrictable;
import org.apache.guacamole.auth.restrict.RestrictionVerificationService;
import org.apache.guacamole.auth.restrict.form.HostRestrictionField;
import org.apache.guacamole.auth.restrict.form.TimeRestrictionField;
import org.apache.guacamole.calendar.RestrictionType;
import org.apache.guacamole.form.Field;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.DelegatingConnectionGroup;
import org.apache.guacamole.protocol.GuacamoleClientInformation;

public class RestrictedConnectionGroup
extends DelegatingConnectionGroup
implements Restrictable {
    private final String remoteAddress;
    public static final String RESTRICT_TIME_ALLOWED_ATTRIBUTE_NAME = "guac-restrict-time-allowed";
    public static final String RESTRICT_TIME_DENIED_ATTRIBUTE_NAME = "guac-restrict-time-denied";
    public static final String RESTRICT_HOSTS_ALLOWED_ATTRIBUTE_NAME = "guac-restrict-hosts-allowed";
    public static final String RESTRICT_HOSTS_DENIED_ATTRIBUTE_NAME = "guac-restrict-hosts-denied";
    public static final List<String> RESTRICT_CONNECTIONGROUP_ATTRIBUTES = Arrays.asList("guac-restrict-time-allowed", "guac-restrict-time-denied", "guac-restrict-hosts-allowed", "guac-restrict-hosts-denied");
    public static final Form RESTRICT_CONNECTIONGROUP_FORM = new Form("restrict-login-form", Arrays.asList(new Field[]{new TimeRestrictionField("guac-restrict-time-allowed"), new TimeRestrictionField("guac-restrict-time-denied"), new HostRestrictionField("guac-restrict-hosts-allowed"), new HostRestrictionField("guac-restrict-hosts-denied")}));

    public RestrictedConnectionGroup(ConnectionGroup connectionGroup, String remoteAddress) {
        super(connectionGroup);
        this.remoteAddress = remoteAddress;
    }

    public ConnectionGroup getUndecorated() {
        return this.getDelegateConnectionGroup();
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(super.getAttributes());
        for (String attribute : RESTRICT_CONNECTIONGROUP_ATTRIBUTES) {
            String value = (String)attributes.get(attribute);
            if (value != null && !value.isEmpty()) continue;
            attributes.put(attribute, null);
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        attributes = new HashMap<String, String>(attributes);
        for (String attribute : RESTRICT_CONNECTIONGROUP_ATTRIBUTES) {
            String value = attributes.get(attribute);
            if (value == null || !value.isEmpty()) continue;
            attributes.put(attribute, null);
        }
        super.setAttributes(attributes);
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        RestrictionVerificationService.verifyConnectionRestrictions(this, this.remoteAddress);
        return super.connect(info, tokens);
    }

    @Override
    public RestrictionType getCurrentTimeRestriction() {
        String allowedTimeString = this.getAttributes().get(RESTRICT_TIME_ALLOWED_ATTRIBUTE_NAME);
        String deniedTimeString = this.getAttributes().get(RESTRICT_TIME_DENIED_ATTRIBUTE_NAME);
        return RestrictionVerificationService.allowedByTimeRestrictions(allowedTimeString, deniedTimeString);
    }

    @Override
    public RestrictionType getCurrentHostRestriction() {
        String allowedHostString = this.getAttributes().get(RESTRICT_HOSTS_ALLOWED_ATTRIBUTE_NAME);
        String deniedHostString = this.getAttributes().get(RESTRICT_HOSTS_DENIED_ATTRIBUTE_NAME);
        return RestrictionVerificationService.allowedByHostRestrictions(allowedHostString, deniedHostString, this.remoteAddress);
    }
}

