/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.restrict.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.restrict.RestrictionVerificationService;
import org.apache.guacamole.auth.restrict.connection.RestrictedConnection;
import org.apache.guacamole.auth.restrict.connectiongroup.RestrictedConnectionGroup;
import org.apache.guacamole.auth.restrict.user.RestrictedUser;
import org.apache.guacamole.auth.restrict.usergroup.RestrictedUserGroup;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.DecoratingDirectory;
import org.apache.guacamole.net.auth.DelegatingUserContext;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedUserContext
extends DelegatingUserContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictedUserContext.class);
    private final String remoteAddress;
    private final Set<String> effectiveUserGroups;

    public RestrictedUserContext(UserContext userContext, String remoteAddress, Set<String> effectiveUserGroups) {
        super(userContext);
        this.remoteAddress = remoteAddress;
        this.effectiveUserGroups = effectiveUserGroups;
    }

    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return new DecoratingDirectory<Connection>(super.getConnectionDirectory()){

            protected Connection decorate(Connection object) throws GuacamoleException {
                return new RestrictedConnection(object, RestrictedUserContext.this.remoteAddress);
            }

            protected Connection undecorate(Connection object) {
                assert (object instanceof RestrictedConnection);
                return ((RestrictedConnection)object).getUndecorated();
            }
        };
    }

    public Collection<Form> getConnectionAttributes() {
        HashSet<Form> connectionAttrs = new HashSet<Form>(super.getConnectionAttributes());
        connectionAttrs.add(RestrictedConnection.RESTRICT_CONNECTION_FORM);
        return Collections.unmodifiableCollection(connectionAttrs);
    }

    public Directory<ConnectionGroup> getConnectionGroupDirectory() throws GuacamoleException {
        return new DecoratingDirectory<ConnectionGroup>(super.getConnectionGroupDirectory()){

            protected ConnectionGroup decorate(ConnectionGroup object) throws GuacamoleException {
                return new RestrictedConnectionGroup(object, RestrictedUserContext.this.remoteAddress);
            }

            protected ConnectionGroup undecorate(ConnectionGroup object) {
                assert (object instanceof RestrictedConnectionGroup);
                return ((RestrictedConnectionGroup)object).getUndecorated();
            }
        };
    }

    public Collection<Form> getConnectionGroupAttributes() {
        HashSet<Form> connectionGroupAttrs = new HashSet<Form>(super.getConnectionGroupAttributes());
        connectionGroupAttrs.add(RestrictedConnectionGroup.RESTRICT_CONNECTIONGROUP_FORM);
        return Collections.unmodifiableCollection(connectionGroupAttrs);
    }

    public Directory<User> getUserDirectory() throws GuacamoleException {
        Permissions currentPermissions = this.self().getEffectivePermissions();
        final boolean isAdmin = currentPermissions.getSystemPermissions().hasPermission(SystemPermission.Type.ADMINISTER);
        final Collection adminIdentifiers = currentPermissions.getUserPermissions().getAccessibleObjects(Collections.singletonList(ObjectPermission.Type.ADMINISTER), (Collection)super.getUserDirectory().getIdentifiers());
        return new DecoratingDirectory<User>(super.getUserDirectory()){

            protected User decorate(User object) throws GuacamoleException {
                boolean hasAdmin = isAdmin || adminIdentifiers.contains(object.getIdentifier());
                return new RestrictedUser(object, RestrictedUserContext.this.remoteAddress, hasAdmin);
            }

            protected User undecorate(User object) {
                assert (object instanceof RestrictedUser);
                return ((RestrictedUser)object).getUndecorated();
            }
        };
    }

    public Collection<Form> getUserAttributes() {
        HashSet<Form> userAttrs = new HashSet<Form>(super.getUserAttributes());
        userAttrs.add(RestrictedUser.RESTRICT_LOGIN_FORM);
        return Collections.unmodifiableCollection(userAttrs);
    }

    public Directory<UserGroup> getUserGroupDirectory() throws GuacamoleException {
        return new DecoratingDirectory<UserGroup>(super.getUserGroupDirectory()){

            protected UserGroup decorate(UserGroup object) {
                return new RestrictedUserGroup(object);
            }

            protected UserGroup undecorate(UserGroup object) {
                assert (object instanceof RestrictedUserGroup);
                return ((RestrictedUserGroup)object).getUndecorated();
            }
        };
    }

    public Collection<Form> getUserGroupAttributes() {
        HashSet<Form> userGroupAttrs = new HashSet<Form>(super.getUserGroupAttributes());
        userGroupAttrs.add(RestrictedUserGroup.RESTRICT_LOGIN_FORM);
        return Collections.unmodifiableCollection(userGroupAttrs);
    }

    public boolean isValid() {
        try {
            RestrictionVerificationService.verifyTimeRestrictions((UserContext)this, this.effectiveUserGroups);
            return true;
        }
        catch (GuacamoleException e) {
            LOGGER.debug("User account is now restricted and is no longer valid", (Throwable)e);
            return false;
        }
    }
}

