/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(JmxClassLoader.class);
    private static final String[] WHITE_PRE_LIST = new String[]{"java.", "javax.management.", "org.apache.hertzbeat.", "org.springframework.util.", "com.sun.", "sun.", "org.slf4j.", "jdk.", "org.w3c.dom."};

    public JmxClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String whitePre : WHITE_PRE_LIST) {
            if (!name.startsWith(whitePre)) continue;
            return super.loadClass(name, resolve);
        }
        log.error("Security vulnerability detection in JMX collect: Forbidden class: {}", (Object)name);
        throw new ClassNotFoundException("Forbidden unsafe collection request content");
    }
}

