/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class WorkerPool
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(WorkerPool.class);
    private ThreadPoolExecutor workerExecutor;

    public WorkerPool() {
        this.initWorkExecutor();
    }

    private void initWorkExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("[Important] WorkerPool workerExecutor has uncaughtException.", throwable);
            log.error("Thread Name {} : {}", new Object[]{thread.getName(), throwable.getMessage(), throwable});
        }).setDaemon(true).setNameFormat("collect-worker-%d").build();
        int coreSize = Math.max(2, Runtime.getRuntime().availableProcessors());
        int maxSize = Runtime.getRuntime().availableProcessors() * 16;
        this.workerExecutor = new ThreadPoolExecutor(coreSize, maxSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void executeJob(Runnable runnable) throws RejectedExecutionException {
        this.workerExecutor.execute(runnable);
    }

    public void destroy() throws Exception {
        if (this.workerExecutor != null) {
            this.workerExecutor.shutdownNow();
        }
    }
}

