/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class DmDriver
extends Filterable
implements Driver {
    public static final String VERSION = "8.1.2.141";
    public static final String BUILD_DATE = "2022.07.26";
    public static final String SVN = "11496";
    public static final String VERSION_JDBC = "4.0";
    private static final String URL_PREFIX = "jdbc:dm://";
    private static final String URL_PREFIX_COMPATIBALE_ORACLE_2 = "jdbc:oracle:@";
    private static final String URL_PREFIX_COMPATIBALE_ORACLE = "jdbc:oracle:thin:@";
    public static final long STARTUP_TIME = System.currentTimeMillis();
    public static DmDriver driver = new DmDriver();
    private static final Map epGroupMap = new ConcurrentHashMap();
    public static AtomicLong IDGenerator;

    static {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (Exception exception) {
            DBError.throwRuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
        }
        IDGenerator = new AtomicLong(0L);
    }

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmDriver() {
        super(null, null);
    }

    public static void main(String[] stringArray) {
        System.out.println("V8.1.2.141-Build(2022.07.26-11496)");
    }

    public DmdbConnection do_connect(DmProperties dmProperties) {
        if (dmProperties == null) {
            return null;
        }
        DmdbConnection dmdbConnection = null;
        EPGroup ePGroup = (EPGroup)dmProperties.getObject(Configuration.epGroup.getName());
        if (ePGroup != null) {
            ePGroup.setAttributes(dmProperties);
            dmdbConnection = new DmdbConnection(dmProperties);
            ePGroup.connect(dmdbConnection);
        } else {
            String string = dmProperties.getTrimString(Configuration.host);
            int n2 = dmProperties.getInt(Configuration.port);
            ArrayList<EP> arrayList = new ArrayList<EP>(1);
            arrayList.add(new EP(string, n2));
            ePGroup = new EPGroup(String.valueOf(string) + ":" + n2, arrayList);
            ePGroup.props = dmProperties;
            ePGroup.setAttributes(dmProperties);
            dmProperties.setObject(Configuration.epGroup.getName(), ePGroup);
            dmdbConnection = new DmdbConnection(dmProperties);
            ePGroup.connect(dmdbConnection);
        }
        return dmdbConnection;
    }

    private int oraclePrefix(String string) {
        int n2 = -1;
        if (string.startsWith(URL_PREFIX_COMPATIBALE_ORACLE)) {
            n2 = URL_PREFIX_COMPATIBALE_ORACLE.length();
        } else if (string.startsWith(URL_PREFIX_COMPATIBALE_ORACLE_2)) {
            n2 = URL_PREFIX_COMPATIBALE_ORACLE_2.length();
        }
        return n2;
    }

    private DmProperties parseURL(String string, Properties properties) {
        Object object;
        Object object2;
        string = StringUtil.trimToEmpty(string);
        int n2 = string.indexOf("?");
        String string2 = string;
        String string3 = "";
        if (n2 != -1) {
            string2 = string.substring(0, n2);
            string3 = StringUtil.trimToEmpty(string.substring(n2 + 1));
        }
        string2 = StringUtil.trimDeep(string2);
        String string4 = string2.toLowerCase();
        int n3 = -1;
        if (string4.startsWith(URL_PREFIX)) {
            string2 = string4.substring(URL_PREFIX.length());
        } else {
            n3 = this.oraclePrefix(string4);
            if (n3 > 0) {
                string2 = string4.substring(n3);
            } else {
                return null;
            }
        }
        DmProperties dmProperties = new DmProperties();
        dmProperties.setProperties(properties);
        if (StringUtil.isNotEmpty(string3)) {
            String[] stringArray = object2 = string3.split("&");
            int n4 = ((String[])object2).length;
            int n5 = 0;
            while (n5 < n4) {
                object = stringArray[n5];
                int n6 = ((String)object).indexOf("=");
                if (n6 != -1) {
                    String string5 = StringUtil.trimToEmpty(((String)object).substring(0, n6));
                    String string6 = StringUtil.trimToEmpty(((String)object).substring(n6 + 1));
                    if (string6.startsWith("\"") && string6.endsWith("\"")) {
                        string6 = StringUtil.trimToEmpty(string6.substring(1, string6.length() - 1));
                    } else if (string6.startsWith("(") && string6.endsWith(")")) {
                        string6 = StringUtil.trimToEmpty(string6.substring(1, string6.length() - 1));
                    }
                    Configuration configuration = Configuration.valueOf(string5);
                    if (configuration == null) {
                        dmProperties.setProperty(string5, string6);
                    } else {
                        if (configuration == Configuration.addressRemap || configuration == Configuration.userRemap) {
                            String string7 = dmProperties.getProperty(configuration.getName());
                            string6 = StringUtil.isNotEmpty(string7) ? String.valueOf(string7) + "&(" + string6.trim() + ")" : "(" + string6.trim() + ")";
                        }
                        dmProperties.setProperty(configuration.getName(), string6.trim());
                    }
                }
                ++n5;
            }
        }
        object = StringUtil.isNotEmpty((String)(object2 = dmProperties.getProperty(Configuration.dmSvcConf.getName(), (String)Configuration.dmSvcConf.getDefault()))) ? DmSvcConf.load((String)object2) : null;
        object = object == null ? DmSvcConf.GLOBAL : object;
        string2 = this.addressRemap(string2, dmProperties, object == null ? null : ((DmSvcConf)object).props);
        dmProperties.setProperty(Configuration.url.getName(), string);
        Configuration.parseHostPort(string2, dmProperties);
        this.userRemap(dmProperties);
        EPGroup ePGroup = this.parseEpGroup(dmProperties, (DmSvcConf)object);
        dmProperties.setNonExistProperties(ePGroup != null ? ePGroup.props : ((DmSvcConf)object).props);
        if (n3 > 0 && Configuration.parseCompatibleMode(dmProperties) != 1) {
            return null;
        }
        return dmProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EPGroup parseEpGroup(DmProperties dmProperties, DmSvcConf dmSvcConf) {
        String string = dmProperties.getString(Configuration.host);
        EPGroup ePGroup = null;
        String string2 = dmProperties.getProperty(string);
        if (StringUtil.isNotEmpty(string2)) {
            String string3 = StringUtil.trimToEmpty(string2);
            Map map = epGroupMap;
            synchronized (map) {
                String string4 = String.valueOf(string) + "=" + string3;
                ePGroup = (EPGroup)epGroupMap.get(string4);
                if (ePGroup == null) {
                    if (string3.startsWith("(") && string3.endsWith(")")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    if ((ePGroup = Configuration.parseEpGroup(string, string3)) != null) {
                        ePGroup.props = new DmProperties(dmSvcConf.props);
                        ePGroup.setAttributes(ePGroup.props);
                        epGroupMap.put(string4, ePGroup);
                    }
                }
            }
        }
        if (ePGroup == null) {
            ePGroup = dmSvcConf.getDBGroup(string);
        }
        if (ePGroup != null && ePGroup.epList.size() > 0) {
            dmProperties.setObject(Configuration.epGroup.getName(), ePGroup);
        }
        return ePGroup;
    }

    private String addressRemap(String string, DmProperties dmProperties, DmProperties dmProperties2) {
        String[] stringArray;
        String string2;
        String string3;
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        String string4 = dmProperties == null ? "" : dmProperties.getProperty(Configuration.addressRemap.getName());
        String string5 = string3 = dmProperties2 == null ? "" : dmProperties2.getProperty(Configuration.addressRemap.getName());
        String string6 = StringUtil.isNotEmpty(string4) && StringUtil.isNotEmpty(string3) ? String.valueOf(string4) + "&" + string3 : (string2 = StringUtil.isNotEmpty(string4) ? string4 : string3);
        if (StringUtil.isEmpty(string2)) {
            return string;
        }
        StringUtil.trimDeep(string2);
        String[] stringArray2 = stringArray = string2.split("&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray3;
            String string7 = stringArray2[n3];
            int n4 = string7.indexOf("(");
            int n5 = string7.indexOf(")");
            if (n4 >= 0 && n5 >= 0 && n4 <= n5 && StringUtil.equalsIgnoreCase((stringArray3 = StringUtil.trimToEmpty(string7.substring(n4 + 1, n5)).split(","))[0], string)) {
                string = stringArray3[1];
                break;
            }
            ++n3;
        }
        return string;
    }

    private void userRemap(DmProperties dmProperties) {
        String[] stringArray;
        String string = dmProperties.getProperty(Configuration.user.getName());
        if (StringUtil.isEmpty(string)) {
            return;
        }
        String string2 = dmProperties.getProperty(Configuration.userRemap.getName());
        if (StringUtil.isEmpty(string2)) {
            return;
        }
        StringUtil.trimDeep(string2);
        String[] stringArray2 = stringArray = string2.split("&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray3;
            String string3 = stringArray2[n3];
            int n4 = string3.indexOf("(");
            int n5 = string3.indexOf(")");
            if (n4 >= 0 && n5 >= 0 && n4 <= n5 && StringUtil.equals((stringArray3 = StringUtil.trimToEmpty(string3.substring(n4 + 1, n5)).split(","))[0], string)) {
                dmProperties.setProperty(Configuration.user.getName(), stringArray3[1]);
                break;
            }
            ++n3;
        }
    }

    @Override
    public Connection connect(String string, Properties properties) {
        DmProperties dmProperties = this.parseURL(string, properties);
        if (dmProperties == null) {
            return null;
        }
        DmSvcConf.GLOBAL.setAttributes(dmProperties);
        FilterChain filterChain = this.createFilterChain(null, dmProperties);
        if (filterChain == null) {
            return this.do_connect(dmProperties);
        }
        return filterChain.reset().Driver_connect(this, dmProperties);
    }

    @Override
    public boolean acceptsURL(String string) {
        return this.parseURL(string, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        DmProperties dmProperties = this.parseURL(string, properties);
        ArrayList<DriverPropertyInfo> arrayList = new ArrayList<DriverPropertyInfo>();
        for (Map.Entry entry : Configuration.map.entrySet()) {
            Configuration configuration = (Configuration)entry.getValue();
            if (configuration == null) continue;
            String string2 = dmProperties == null ? StringUtil.trimToEmpty(configuration.getDefault()) : dmProperties.getProperty(configuration.getName(), configuration.getDefault() == null ? "" : configuration.getDefault().toString());
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(configuration.getName(), string2);
            driverPropertyInfo.description = configuration.getDescription();
            driverPropertyInfo.required = configuration.isRequired();
            driverPropertyInfo.choices = StringUtil.toStringArray(configuration.getValidValues());
            arrayList.add(driverPropertyInfo);
        }
        return arrayList.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        if (DmSvcConf.GLOBAL.compatibleOracle()) {
            return 11;
        }
        int n2 = VERSION.indexOf(".");
        String string = "7";
        if (n2 != -1) {
            string = VERSION.substring(0, n2);
        }
        return Integer.parseInt(string);
    }

    @Override
    public int getMinorVersion() {
        if (DmSvcConf.GLOBAL.compatibleOracle()) {
            return 1;
        }
        String string = VERSION;
        int n2 = string.indexOf(".");
        int n3 = -1;
        if (n2 != -1) {
            n3 = string.indexOf(".", n2 + 1);
        }
        String string2 = "0";
        if (n2 != -1 && n3 != -1) {
            string2 = string.substring(n2 + 1, n3);
        }
        return Integer.parseInt(string2);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }
}

