/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_status_page_org")
@Schema(description="status page org entity")
@EntityListeners(value={AuditingEntityListener.class})
public class StatusPageOrg {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="ID", example="87584674384")
    private Long id;
    @Schema(title="org name", example="TanCloud")
    @NotBlank
    private String name;
    @Schema(title="org desc", example="TanCloud inc")
    @NotBlank
    private String description;
    @Schema(title="org home url", example="https://tancloud.com")
    @NotBlank
    private String home;
    @Schema(title="org logo url", example="logo.svg url")
    @NotBlank
    private String logo;
    @Schema(title="org feedback issue url", example="contact@email.com")
    private String feedback;
    @Schema(title="org theme background color", example="#ffffff")
    private String color;
    @Schema(title="org current state: 0-All Systems Operational 1-Some Systems Abnormal 2-All Systems Abnormal ", example="0")
    private byte state;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static StatusPageOrgBuilder builder() {
        return new StatusPageOrgBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHome() {
        return this.home;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public String getColor() {
        return this.color;
    }

    public byte getState() {
        return this.state;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusPageOrg)) {
            return false;
        }
        StatusPageOrg other = (StatusPageOrg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$home = this.getHome();
        String other$home = other.getHome();
        if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        String this$feedback = this.getFeedback();
        String other$feedback = other.getFeedback();
        if (this$feedback == null ? other$feedback != null : !this$feedback.equals(other$feedback)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusPageOrg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getState();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $home = this.getHome();
        result = result * 59 + ($home == null ? 43 : $home.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        String $feedback = this.getFeedback();
        result = result * 59 + ($feedback == null ? 43 : $feedback.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "StatusPageOrg(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", home=" + this.getHome() + ", logo=" + this.getLogo() + ", feedback=" + this.getFeedback() + ", color=" + this.getColor() + ", state=" + this.getState() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public StatusPageOrg(Long id, String name, String description, String home, String logo, String feedback, String color, byte state, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.home = home;
        this.logo = logo;
        this.feedback = feedback;
        this.color = color;
        this.state = state;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public StatusPageOrg() {
    }

    public static class StatusPageOrgBuilder {
        private Long id;
        private String name;
        private String description;
        private String home;
        private String logo;
        private String feedback;
        private String color;
        private byte state;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        StatusPageOrgBuilder() {
        }

        public StatusPageOrgBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StatusPageOrgBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StatusPageOrgBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StatusPageOrgBuilder home(String home) {
            this.home = home;
            return this;
        }

        public StatusPageOrgBuilder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public StatusPageOrgBuilder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        public StatusPageOrgBuilder color(String color) {
            this.color = color;
            return this;
        }

        public StatusPageOrgBuilder state(byte state) {
            this.state = state;
            return this;
        }

        public StatusPageOrgBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public StatusPageOrgBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public StatusPageOrgBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public StatusPageOrgBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public StatusPageOrg build() {
            return new StatusPageOrg(this.id, this.name, this.description, this.home, this.logo, this.feedback, this.color, this.state, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "StatusPageOrg.StatusPageOrgBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", home=" + this.home + ", logo=" + this.logo + ", feedback=" + this.feedback + ", color=" + this.color + ", state=" + this.state + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

