/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerImpl;
import org.apache.flink.runtime.metrics.ThresholdMeter;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.active.ActiveResourceManager;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;

public abstract class ActiveResourceManagerFactory<WorkerType extends ResourceIDRetrievable>
extends ResourceManagerFactory<WorkerType> {
    @Override
    protected Configuration getEffectiveConfigurationForResourceManagerAndRuntimeServices(Configuration configuration) {
        return TaskExecutorProcessUtils.getConfigurationMapLegacyTaskManagerHeapSizeToConfigOption(configuration, (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_PROCESS_MEMORY);
    }

    @Override
    protected Configuration getEffectiveConfigurationForResourceManager(Configuration configuration) {
        if (ClusterOptions.isFineGrainedResourceManagementEnabled((Configuration)configuration)) {
            Configuration copiedConfig = new Configuration(configuration);
            if (copiedConfig.removeConfig(TaskManagerOptions.TOTAL_PROCESS_MEMORY)) {
                this.logIgnoreTotalMemory((ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_PROCESS_MEMORY);
            }
            if (copiedConfig.removeConfig(TaskManagerOptions.TOTAL_FLINK_MEMORY)) {
                this.logIgnoreTotalMemory((ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_FLINK_MEMORY);
            }
            return copiedConfig;
        }
        return configuration;
    }

    private void logIgnoreTotalMemory(ConfigOption<MemorySize> option) {
        this.log.warn("Configured size for '{}' is ignored. Total memory size for TaskManagers are dynamically decided in fine-grained resource management.", (Object)option.key());
    }

    @Override
    public ResourceManager<WorkerType> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, UUID leaderSessionId, HeartbeatServices heartbeatServices, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, ResourceManagerMetricGroup resourceManagerMetricGroup, ResourceManagerRuntimeServices resourceManagerRuntimeServices, Executor ioExecutor) throws Exception {
        ThresholdMeter failureRater = ActiveResourceManagerFactory.createStartWorkerFailureRater(configuration);
        Duration retryInterval = (Duration)configuration.get(ResourceManagerOptions.START_WORKER_RETRY_INTERVAL);
        Duration workerRegistrationTimeout = (Duration)configuration.get(ResourceManagerOptions.TASK_MANAGER_REGISTRATION_TIMEOUT);
        return new ActiveResourceManager<WorkerType>(this.createResourceManagerDriver(configuration, webInterfaceUrl, rpcService.getAddress()), configuration, rpcService, leaderSessionId, resourceId, heartbeatServices, resourceManagerRuntimeServices.getSlotManager(), ResourceManagerPartitionTrackerImpl::new, resourceManagerRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, failureRater, retryInterval, workerRegistrationTimeout, ioExecutor);
    }

    protected abstract ResourceManagerDriver<WorkerType> createResourceManagerDriver(Configuration var1, @Nullable String var2, String var3) throws Exception;

    public static ThresholdMeter createStartWorkerFailureRater(Configuration configuration) {
        double rate = configuration.getDouble(ResourceManagerOptions.START_WORKER_MAX_FAILURE_RATE);
        if (rate <= 0.0) {
            throw new IllegalConfigurationException(String.format("Configured max start worker failure rate ('%s') must be larger than 0. Current: %f", ResourceManagerOptions.START_WORKER_MAX_FAILURE_RATE.key(), rate));
        }
        return new ThresholdMeter(rate, Duration.ofMinutes(1L));
    }
}

