/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch.forwardgroup;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class ForwardGroup {
    private int parallelism = -1;
    private final Set<JobVertexID> jobVertexIds = new HashSet<JobVertexID>();

    public ForwardGroup(Set<ExecutionJobVertex> jobVertices) {
        Preconditions.checkNotNull(jobVertices);
        Set decidedParallelisms = jobVertices.stream().filter(jobVertex -> {
            this.jobVertexIds.add(jobVertex.getJobVertexId());
            return jobVertex.isParallelismDecided();
        }).map(ExecutionJobVertex::getParallelism).collect(Collectors.toSet());
        Preconditions.checkState((decidedParallelisms.size() <= 1 ? 1 : 0) != 0);
        if (decidedParallelisms.size() == 1) {
            this.parallelism = (Integer)decidedParallelisms.iterator().next();
        }
    }

    public void setParallelism(int parallelism) {
        Preconditions.checkState((this.parallelism == -1 ? 1 : 0) != 0);
        this.parallelism = parallelism;
    }

    public boolean isParallelismDecided() {
        return this.parallelism > 0;
    }

    public int getParallelism() {
        Preconditions.checkState((boolean)this.isParallelismDecided());
        return this.parallelism;
    }

    public int size() {
        return this.jobVertexIds.size();
    }

    public Set<JobVertexID> getJobVertexIds() {
        return this.jobVertexIds;
    }
}

