/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class Signature {
    private final List<Argument> arguments;

    private Signature(List<Argument> arguments) {
        this.arguments = (List)Preconditions.checkNotNull(arguments, (String)"Argument must not be null.");
    }

    public static Signature of(Argument ... arguments) {
        return new Signature(Arrays.asList(arguments));
    }

    public static Signature of(List<Argument> arguments) {
        return new Signature(arguments);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    @PublicEvolving
    public static final class Argument {
        @Nullable
        private final String name;
        private final String type;

        private Argument(@Nullable String name, String type) {
            this.name = name;
            this.type = (String)Preconditions.checkNotNull((Object)type);
        }

        public static Argument of(String name, String type) {
            return new Argument((String)Preconditions.checkNotNull((Object)name, (String)"Name must not be null."), type);
        }

        public static Argument of(String type) {
            return new Argument(null, type);
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public String getType() {
            return this.type;
        }
    }
}

