/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.flume.Transaction;
import org.apache.inlong.dataproxy.utils.BufferQueue;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyTransaction
implements Transaction {
    public static final Logger LOG = LoggerFactory.getLogger(ProxyTransaction.class);
    private Semaphore countSemaphore;
    private BufferQueue<ProxyEvent> bufferQueue;
    private List<ProxyEvent> takeList = new ArrayList<ProxyEvent>();
    private List<ProxyEvent> putList = new ArrayList<ProxyEvent>();

    public ProxyTransaction(Semaphore countSemaphore, BufferQueue<ProxyEvent> bufferQueue) {
        this.countSemaphore = countSemaphore;
        this.bufferQueue = bufferQueue;
    }

    public void begin() {
    }

    public void commit() {
        for (ProxyEvent event : this.takeList) {
            this.countSemaphore.release();
            this.bufferQueue.release(event.getBody().length);
        }
        this.takeList.clear();
        for (ProxyEvent event : this.putList) {
            this.bufferQueue.offer(event);
        }
        this.putList.clear();
    }

    public void rollback() {
        for (ProxyEvent event : this.takeList) {
            this.bufferQueue.offer(event);
        }
        this.takeList.clear();
        for (ProxyEvent event : this.putList) {
            this.countSemaphore.release();
            this.bufferQueue.release(event.getBody().length);
        }
        this.putList.clear();
    }

    public void close() {
    }

    public void doTake(ProxyEvent event) {
        this.takeList.add(event);
    }

    public void doPut(ProxyEvent event) {
        this.putList.add(event);
    }
}

